/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cds.feature.mt.lib.subscription.json;

import java.io.IOException;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;

public class Cloner {
	private static final ObjectMapper mapper = new ObjectMapper();

	private Cloner() {
	}

	@SuppressWarnings("unchecked")
	public static <T> T clone(T source) throws InternalError {
		if (source == null) return null;
		try {
			return (T) mapper.readValue(mapper.writeValueAsString(source), source.getClass());
		} catch (IOException e) {
			throw new InternalError("Could not convert between object and json", e);
		}
	}
}
