/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;

import java.util.Map;

/**
 * Payload used for the callback to the SaaS Registry.
 */
public interface SaasRegistryCallback extends CdsData {

	static SaasRegistryCallback create() {
		return Struct.create(SaasRegistryCallback.class);
	}

	static SaasRegistryCallback create(Map<String, Object> attributes) {
		return Struct.access(attributes).as(SaasRegistryCallback.class);
	}

	/**
	 * Gets the status.
	 * 
	 * @return SUCCEEDED or FAILED
	 */
	String getStatus();

	/**
	 * Sets the status.
	 * 
	 * @param status SUCCEEDED or FAILED
	 */
	void setStatus(String status);

	/**
	 * Gets the success/failure message.
	 * 
	 * @return the message
	 */
	String getMessage();

	/**
	 * Sets the success/failure message.
	 * 
	 * @param message the message
	 */
	void setMessage(String message);

	/**
	 * Sets the subscription url.
	 * 
	 * @param url the subscription url
	 */
	void setSubscriptionUrl(String url);
}
