/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.ServiceOperation;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ServiceBinding
extends HashMap<String, Object> {
    public static final String CREDENTIALS = "credentials";
    public static final String SERVICE_INSTANCE_ID = "service_instance_id";
    public static final String ID = "id";
    public static final String NAME = "name";
    private final ServiceOperation lastOperation;

    public ServiceBinding(Map<String, ?> m) {
        super(m);
        this.lastOperation = new ServiceOperation(m != null ? m : new HashMap());
    }

    public String getId() {
        return this.containsKey(ID) ? (String)this.get(ID) : "";
    }

    public boolean isReady() {
        return this.containsKey("ready") && (Boolean)this.get("ready") != false;
    }

    public String getName() {
        return this.containsKey(NAME) ? (String)this.get(NAME) : "";
    }

    public String getServiceInstanceId() {
        return this.containsKey(SERVICE_INSTANCE_ID) ? (String)this.get(SERVICE_INSTANCE_ID) : "";
    }

    public Instant getCreatedAt() {
        return Instant.parse((String)this.get("created_at"));
    }

    public Instant getUpdatedAt() {
        return Instant.parse((String)this.get("updated_at"));
    }

    public Map<String, Object> getCredentials() {
        return this.containsKey(CREDENTIALS) ? (Map)this.get(CREDENTIALS) : new HashMap();
    }

    public ServiceOperation getLastOperation() {
        return this.lastOperation;
    }

    public List<String> getTenants() {
        Map labels = (Map)this.get("labels");
        if (labels == null) {
            return new ArrayList<String>();
        }
        List tenants = (List)labels.get("tenant_id");
        return tenants != null ? tenants.stream().filter(t -> !StringUtils.isBlank((CharSequence)t)).toList() : new ArrayList<String>();
    }

    public boolean hasTenant() {
        return !this.getTenants().isEmpty();
    }

    boolean isUsable() {
        ServiceOperation.Status status = this.lastOperation.getStatus();
        return this.isReady() && !this.getCredentials().isEmpty() && (this.lastOperation.getType() != ServiceOperation.Type.CREATE || status != ServiceOperation.Status.FAILED && status != ServiceOperation.Status.IN_PROGRESS);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBinding that = (ServiceBinding)o;
        return Objects.equals(this.lastOperation, that.lastOperation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lastOperation);
    }
}

