/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.sap.cds.feature.mt.DatabaseSchemaIdProvider;
import com.sap.cds.feature.mt.MtUtils;
import com.sap.cds.feature.mt.lib.runtime.DataPoolSettings;
import com.sap.cds.feature.mt.lib.runtime.DataSourceLookup;
import com.sap.cds.feature.mt.lib.runtime.DataSourceLookupBuilder;
import com.sap.cds.feature.mt.lib.runtime.EnvironmentAccess;
import com.sap.cds.feature.mt.lib.runtime.IdentityZoneDeterminer;
import com.sap.cds.feature.mt.lib.runtime.TenantAwareDataSource;
import com.sap.cds.feature.mt.lib.runtime.TenantProvider;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManager;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.datasource.DataSourceFactory;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.datasource.DataSourceUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;

public class RoutingDataSourceFactory
implements DataSourceFactory,
CdsRuntimeAware {
    private static final String DATA_SOURCE_SECTION_MT = "cds.multitenancy.datasource.";
    private CdsRuntime runtime;
    private MtUtils mtUtils;

    public void setCdsRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
        this.mtUtils = new MtUtils(runtime);
    }

    public Map<String, DataSource> create() {
        HashMap<String, DataSource> dataSources = new HashMap<String, DataSource>();
        for (Map.Entry<String, InstanceLifecycleManager> entry : this.mtUtils.createInstanceLifecycleManagers(this.runtime.getEnvironment().getCdsProperties().getMultiTenancy().getServiceManager().getV2().isEnabled()).entrySet()) {
            dataSources.put(entry.getKey(), this.createRoutingDataSource(entry.getKey(), entry.getValue()));
        }
        return dataSources;
    }

    private DataSource createRoutingDataSource(final String name, InstanceLifecycleManager ilm) {
        Map<String, DataPoolSettings.ConnectionPoolType> parameterConfig = this.createParameterConfig(name);
        CdsProperties.MultiTenancy multiTenancy = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy();
        DataSourceLookup lookup = DataSourceLookupBuilder.create().instanceLifecycleManager(ilm).environmentAccess(new EnvironmentAccess(){

            @Override
            public <T> T getProperty(String key, Class<T> clazz) {
                return (T)RoutingDataSourceFactory.this.runtime.getEnvironment().getProperty(key, clazz, null);
            }

            @Override
            public Map<Object, Object> getPropertiesForPrefix(String prefix) {
                return this.getProperty(prefix, HashMap.class);
            }
        }).prefixToPoolType(parameterConfig).poolProvider(multiTenancy.getDataSource().getPool()).combinePools(multiTenancy.getDataSource().getCombinePools().isEnabled()).build();
        TenantProvider provider = new TenantProvider(new IdentityZoneDeterminer(){

            @Override
            public String getIdentityZone() throws InternalError {
                String tenant;
                UserInfo userInfo = RequestContext.getCurrent((CdsRuntime)RoutingDataSourceFactory.this.runtime).getUserInfo();
                DatabaseSchemaIdProvider providedMapper = (DatabaseSchemaIdProvider)RoutingDataSourceFactory.this.runtime.getProvider(DatabaseSchemaIdProvider.class);
                String string = tenant = providedMapper != null ? providedMapper.get(userInfo, name) : userInfo.getTenant();
                if (tenant == null) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TENANT_CONTEXT_MISSING, new Object[0]);
                }
                return tenant;
            }
        });
        return new TenantAwareDataSource(provider, lookup, this.runtime);
    }

    private Map<String, DataPoolSettings.ConnectionPoolType> createParameterConfig(String name) {
        LinkedHashMap<String, DataPoolSettings.ConnectionPoolType> config = new LinkedHashMap<String, DataPoolSettings.ConnectionPoolType>();
        this.addConfigParameter(config, DataPoolSettings.ConnectionPoolType.HIKARI, DataSourceUtils.PoolType.HIKARI, name);
        this.addConfigParameter(config, DataPoolSettings.ConnectionPoolType.TOMCAT, DataSourceUtils.PoolType.TOMCAT, name);
        return config;
    }

    private void addConfigParameter(Map<String, DataPoolSettings.ConnectionPoolType> config, DataPoolSettings.ConnectionPoolType type, DataSourceUtils.PoolType poolType, String name) {
        config.put(DataSourceUtils.getDataSourceSection((String)name, (DataSourceUtils.PoolType)poolType), type);
        config.put(DATA_SOURCE_SECTION_MT + poolType, type);
    }
}

