/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.event.TenantOffboardedEventContext;
import com.sap.cds.services.auditlog.event.TenantOnboardedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.SubscribeEventContext;
import com.sap.cds.services.mt.UnsubscribeEventContext;

@ServiceName(value={"DeploymentService$Default"})
public class TenantSubscriptionAuditLogHandler
implements EventHandler {
    private final AuditLogService auditLog;

    public TenantSubscriptionAuditLogHandler(AuditLogService auditLog) {
        this.auditLog = auditLog;
    }

    @After
    public void afterSubscribe(SubscribeEventContext context) {
        TenantOnboardedEventContext ctx = TenantOnboardedEventContext.create();
        ctx.put("tenant", (Object)context.getTenant());
        this.auditLog.emit((EventContext)ctx);
    }

    @After
    public void afterUnsubscribe(UnsubscribeEventContext context) {
        TenantOffboardedEventContext ctx = TenantOffboardedEventContext.create();
        ctx.put("tenant", (Object)context.getTenant());
        this.auditLog.emit((EventContext)ctx);
    }
}

