/*
 * © 2024-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import java.sql.Connection;
import java.sql.SQLException;

public class GenericConnectionProviderOnePoolPerTenant implements ConnectionProvider {

  @Override
  public Connection getConnection(
      String tenantId, DataSourceAndInfo dataSourceAndInfo, DataSourceInfo libContainerInfo)
      throws SQLException {
    return dataSourceAndInfo.getDataSource().getConnection(); // NOSONAR
  }
}
