/*
 * © 2024-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import java.sql.Connection;
import java.sql.SQLException;

public class SchemalessConnectionProvider implements ConnectionProvider {

  @Override
  public Connection getConnection(
      String tenantId, DataSourceAndInfo dataSourceAndInfo, DataSourceInfo libContainerInfo)
      throws SQLException {
    // For SQLite, the driver does not allow to manage the schema (it is always null)
    return dataSourceAndInfo.getDataSource().getConnection();
  }
}
