/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

import java.time.Duration;

public class PollingParameters {
  public static final PollingParameters DEFAULT =
      Builder.create().interval(Duration.ofSeconds(10)).timeout(Duration.ofMinutes(10)).build();

  /** The time waited between polling calls. */
  private Duration interval;

  /** Maximum waiting time for a remote operation */
  private Duration requestTimeout;

  private PollingParameters() {}

  public Duration getInterval() {
    return interval;
  }

  public void setInterval(Duration interval) {
    this.interval = interval;
  }

  public Duration getRequestTimeout() {
    return requestTimeout;
  }

  public void setRequestTimeout(Duration requestTimeout) {
    this.requestTimeout = requestTimeout;
  }

  public static final class Builder {
    private Duration interval = Duration.ofSeconds(5);
    private Duration timeout = Duration.ofMinutes(10);

    private Builder() {}

    public static Builder create() {
      return new Builder();
    }

    public Builder interval(Duration interval) {
      this.interval = interval;
      return this;
    }

    public Builder timeout(Duration timeout) {
      this.timeout = timeout;
      return this;
    }

    public PollingParameters build() {
      PollingParameters pollingParameters = new PollingParameters();
      pollingParameters.setInterval(interval);
      pollingParameters.setRequestTimeout(timeout);
      return pollingParameters;
    }
  }
}
