/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

import java.util.Map;

public class SubscriptionPayloadAccessForSaasRegistry implements SubscriptionPayloadAccess {
  public static final String GLOBAL_ACCOUNT_GUID = "globalAccountGUID";
  public static final String SUBACCOUNT_ID = "subscribedSubaccountId";
  public static final String APP_NAME = "subscriptionAppName";
  public static final String SUBSCRIBED_SUBDOMAIN = "subscribedSubdomain";
  private final Map<String, Object> payload;
  public static final String EVENT_TYPE = "eventType";

  public SubscriptionPayloadAccessForSaasRegistry(Map<String, Object> payload) {
    this.payload = payload;
  }

  @Override
  public String getGlobalAccountId() {
    return payload.containsKey(GLOBAL_ACCOUNT_GUID)
        ? (String) payload.get(GLOBAL_ACCOUNT_GUID)
        : "";
  }

  @Override
  public String getSubAccountId() {
    return payload.containsKey(SUBACCOUNT_ID) ? (String) payload.get(SUBACCOUNT_ID) : "";
  }

  @Override
  public String getApplicationName() {
    return payload.containsKey(APP_NAME) ? (String) payload.get(APP_NAME) : "";
  }

  @Override
  public String getEventType() {
    return payload.containsKey(EVENT_TYPE) ? (String) payload.get(EVENT_TYPE) : "";
  }

  @Override
  public String getSubDomain() {
    return payload.containsKey(SUBSCRIBED_SUBDOMAIN)
        ? (String) payload.get(SUBSCRIBED_SUBDOMAIN)
        : "";
  }
}
