/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

import java.util.concurrent.ConcurrentHashMap;

public class TenantMutexFactory {
  private static final ConcurrentHashMap<String, TenantMutex> tenantToMutex =
      new ConcurrentHashMap<>();

  private TenantMutexFactory() {}

  public static TenantMutex get(String tenantId) {
    TenantMutex mutex = tenantToMutex.get(tenantId);
    if (mutex != null) {
      return mutex;
    }
    TenantMutex newMutex = new TenantMutex();
    TenantMutex storedMutex = tenantToMutex.putIfAbsent(tenantId, newMutex);
    if (storedMutex != null) {
      return storedMutex;
    } else {
      return newMutex;
    }
  }
}
