/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.tools;

public class PollingResponse<T> {
  private boolean finished;
  private Exception exception;
  private T result;

  public PollingResponse() {}

  public PollingResponse(boolean finished, Exception exception, T result) {
    this.finished = finished;
    this.exception = exception;
    this.result = result;
  }

  public void copyFrom(PollingResponse<T> source) {
    finished = source.isFinished();
    exception = source.getException();
    result = source.getResult();
  }

  public boolean isFinished() {
    return finished;
  }

  public void setFinished(boolean finished) {
    this.finished = finished;
  }

  public Exception getException() {
    return exception;
  }

  public void setException(Exception exception) {
    this.exception = exception;
  }

  public T getResult() {
    return result;
  }

  public void setResult(T result) {
    this.result = result;
  }
}
