/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.mt;

import com.sap.cds.CdsData;

/**
 * This interface provides more details about the user who triggered the subscription or
 * unsubscription.
 */
public interface SaasRegistryTriggeredByInfo extends CdsData {

  String getUserId();

  /**
   * The user as defined in the configured IdP, usually would be the email address of the user.
   *
   * @return The user as defined in the configured IdP, usually would be the email address of the
   *     user.
   */
  String getUserName();

  /**
   * The email address of the user.
   *
   * @return the email address of the user.
   */
  String getEmail();

  /**
   * In case of default SAP IdP, would contain the ID of the user ID.
   *
   * @return In case of default SAP IdP, would contain the ID of the user ID.
   */
  String getSubIdp();

  String getSub();
}
