/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.DatabaseConnectionProvider;
import com.sap.cds.feature.mt.lib.runtime.ConnectionProvider;
import com.sap.cds.feature.mt.lib.runtime.GenericConnectionProvider;
import com.sap.cds.feature.mt.lib.runtime.GenericConnectionProviderOnePoolPerTenant;
import com.sap.cds.feature.mt.lib.runtime.HanaConnectionProvider;
import com.sap.cds.feature.mt.lib.runtime.PoolMode;
import com.sap.cds.feature.mt.lib.runtime.SchemalessConnectionProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProviderFunction
implements BiFunction<String, PoolMode, ConnectionProvider> {
    private static final ConnectionProvider HANA_CONNECTION_PROVIDER = new HanaConnectionProvider();
    private static final ConnectionProvider GENERIC_CONNECTION_PROVIDER = new GenericConnectionProvider();
    private static final ConnectionProvider SCHEMALESS_CONNECTION_PROVIDER = new SchemalessConnectionProvider();
    private static final ConnectionProvider GENERIC_CONNECTION_PROVIDER_ONE_POOL_PER_TENANT = new GenericConnectionProviderOnePoolPerTenant();
    private static final Logger logger = LoggerFactory.getLogger(ConnectionProviderFunction.class);
    private final CdsRuntime cdsRuntime;

    public ConnectionProviderFunction(CdsRuntime cdsRuntime) {
        this.cdsRuntime = cdsRuntime;
    }

    @Override
    public ConnectionProvider apply(String driver, PoolMode poolMode) {
        ConnectionProvider customProvider;
        ConnectionProvider connectionProvider = customProvider = this.cdsRuntime != null ? (ConnectionProvider)this.cdsRuntime.getProvider(DatabaseConnectionProvider.class) : null;
        if (customProvider != null) {
            logger.debug("Using custom connection provider {}", customProvider.getClass());
            return customProvider;
        }
        if (poolMode == null) {
            poolMode = PoolMode.POOL_AND_CREDENTIALS_PER_TENANT;
        }
        switch (driver) {
            case "com.sap.db.jdbc.Driver": {
                switch (poolMode) {
                    case POOL_PER_DB_CREDENTIALS_PER_TENANT: {
                        logger.debug("Use HANA connection provider");
                        return HANA_CONNECTION_PROVIDER;
                    }
                    case POOL_AND_CREDENTIALS_PER_TENANT: {
                        logger.debug("Use generic connection provider one pool per tenant");
                        return GENERIC_CONNECTION_PROVIDER_ONE_POOL_PER_TENANT;
                    }
                }
            }
            case "org.sqlite.JDBC": {
                return SCHEMALESS_CONNECTION_PROVIDER;
            }
        }
        logger.debug("Use generic connection provider");
        return GENERIC_CONNECTION_PROVIDER;
    }
}

