/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.lib.runtime.DataPoolSettings;
import com.sap.cds.feature.mt.lib.runtime.EnvironmentAccess;
import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.MtLibError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSourceCreator {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceCreator.class);

    public final DataSource create(DataSourceInfo info, EnvironmentAccess env) throws InternalError {
        DataSource dataSource = this.build(info);
        this.setPoolParameters(dataSource, env);
        return dataSource;
    }

    private void setPoolParameters(DataSource dataSource, EnvironmentAccess env) {
        this.getPoolParameters().forEach(p -> {
            String normalizedNameInEnv = p.getNormalizedNameInEnv();
            Map<Object, Object> para = p.getType() != Properties.class ? env.getProperty(normalizedNameInEnv, p.getType()) : env.getPropertiesForPrefix(normalizedNameInEnv);
            if (para != null) {
                try {
                    if (p.getType() != Properties.class) {
                        this.getMethod(dataSource, (DataPoolSettings.Parameter)p).invoke((Object)dataSource, para);
                    } else {
                        Properties properties = new Properties();
                        properties.putAll(para);
                        this.getMethod(dataSource, (DataPoolSettings.Parameter)p).invoke((Object)dataSource, properties);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new MtLibError(e);
                }
                catch (IllegalArgumentException e) {
                    throw new MtLibError(String.format("Invalid value for parameter '%s': %s (%s), expected value of type (%s)", normalizedNameInEnv, para, para.getClass().getCanonicalName(), p.getType().getCanonicalName()), e);
                }
            }
        });
    }

    protected abstract DataSource build(DataSourceInfo var1) throws InternalError;

    protected abstract Stream<DataPoolSettings.Parameter> getPoolParameters();

    private Method getMethod(DataSource dataSource, DataPoolSettings.Parameter p) throws NoSuchMethodException {
        try {
            return dataSource.getClass().getMethod(p.getSetterName(), p.getType());
        }
        catch (NoSuchMethodException e) {
            logger.debug("Try with another type");
            if (p.getType() == Boolean.TYPE) {
                return dataSource.getClass().getMethod(p.getSetterName(), Boolean.class);
            }
            if (p.getType() == Integer.TYPE) {
                return dataSource.getClass().getMethod(p.getSetterName(), Integer.class);
            }
            if (p.getType() == Long.TYPE) {
                return dataSource.getClass().getMethod(p.getSetterName(), Long.class);
            }
            throw new NoSuchMethodException();
        }
    }
}

