/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.lib.runtime.DataSourceAndInfo;
import com.sap.cds.feature.mt.lib.runtime.HealthCheckResult;
import com.sap.cds.feature.mt.lib.runtime.PoolMode;
import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import com.sap.cds.feature.mt.lib.subscription.DbIdentifiers;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManager;
import com.sap.cds.feature.mt.lib.subscription.MtxTools;
import com.sap.cds.feature.mt.lib.subscription.SqlOperations;
import com.sap.cds.feature.mt.lib.subscription.TenantMutex;
import com.sap.cds.feature.mt.lib.subscription.TenantMutexFactory;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.UnknownTenant;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSourceLookup {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceLookup.class);
    private final ConcurrentHashMap<String, DataSourceAndInfo> tenantToDataSource = new ConcurrentHashMap();
    private final InstanceLifecycleManager instanceLifecycleManager;
    private final LibContainerCache libContainerCache = new LibContainerCache();
    private boolean combinePools = false;

    protected DataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, boolean combinePools) {
        this.instanceLifecycleManager = instanceLifecycleManager;
        this.combinePools = combinePools;
    }

    protected DataSourceLookup(InstanceLifecycleManager instanceLifecycleManager) {
        this(instanceLifecycleManager, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSourceAndInfo getDataSourceAndInfo(String tenantId) throws InternalError, UnknownTenant {
        logger.debug("Determine data source information for tenant {}", (Object)tenantId);
        DataSourceAndInfo dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
        if (dataSourceAndInfo != null) {
            return dataSourceAndInfo;
        }
        TenantMutex tenantMutex = TenantMutexFactory.get(tenantId);
        synchronized (tenantMutex) {
            dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
            if (dataSourceAndInfo != null) {
                return dataSourceAndInfo;
            }
            logger.debug("Access instance manager for tenant {}", (Object)tenantId);
            DataSourceInfo tenantDataSourceInfo = this.instanceLifecycleManager.getDataSourceInfo(tenantId, false);
            String dbKey = tenantDataSourceInfo.getDbKey();
            DataSource dataSource = null;
            if (this.combinePools) {
                dataSource = this.libContainerCache.get(dbKey);
                if (dataSource == null) {
                    this.preparePool(tenantDataSourceInfo);
                    dataSource = this.libContainerCache.get(dbKey);
                    if (dataSource == null) {
                        throw new InternalError("Could not find database pool for db key " + dbKey);
                    }
                }
            } else {
                this.preparePool(tenantDataSourceInfo);
                dataSource = this.create(tenantDataSourceInfo);
            }
            DataSourceAndInfo newEntry = new DataSourceAndInfo(dataSource, tenantDataSourceInfo);
            this.tenantToDataSource.put(tenantId, newEntry);
            return newEntry;
        }
    }

    public boolean isAuthenticationProblem(SQLException sqlException) {
        if (sqlException instanceof SQLInvalidAuthorizationSpecException) {
            return true;
        }
        try {
            SqlOperations sqlOperations = SqlOperations.build(this.instanceLifecycleManager.getDbType());
            return sqlOperations.isAuthenticationProblem(this.determineSqlState(sqlException));
        }
        catch (InternalError e) {
            logger.error("Not supported DB", (Throwable)e);
            return false;
        }
    }

    DataSourceInfo getLibContainerInfo(String dbkey) {
        return this.libContainerCache.getInfo(dbkey);
    }

    protected String determineSqlState(Throwable exception) {
        SQLException sqlException;
        String sqlState;
        if (exception instanceof SQLException && StringUtils.isNotBlank((CharSequence)(sqlState = (sqlException = (SQLException)exception).getSQLState()))) {
            return sqlState;
        }
        if (exception.getCause() != null) {
            return this.determineSqlState(exception.getCause());
        }
        return "";
    }

    private synchronized void preparePool(DataSourceInfo dataSourceInfo) throws InternalError {
        logger.debug("Prepare pool for database key {}", (Object)dataSourceInfo.getDbKey());
        if (this.libContainerCache.isContained(dataSourceInfo.getDbKey())) {
            return;
        }
        List<DataSourceInfo> libContainers = this.instanceLifecycleManager.createAndGetLibContainers(dataSourceInfo);
        libContainers.stream().forEach(this::createAndCachePoolsForLibContainerPools);
    }

    private void createAndCachePoolsForLibContainerPools(DataSourceInfo libContainerInfo) {
        this.libContainerCache.createIfNotExist(libContainerInfo.getDbKey(), () -> this.create(libContainerInfo), libContainerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixDataSourceAfterCredentialChange(String tenantId, DataSource usedPool) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            logger.debug("No tenant specified");
            throw new InternalError("No tenant specified");
        }
        TenantMutex tenantMutex = TenantMutexFactory.get(tenantId);
        synchronized (tenantMutex) {
            DataSourceInfo freshInfo;
            DataSourceAndInfo dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
            if (dataSourceAndInfo == null || usedPool != dataSourceAndInfo.getDataSource()) {
                return;
            }
            DataSourceInfo cachedInfo = dataSourceAndInfo.getDataSourceInfo();
            try {
                freshInfo = this.instanceLifecycleManager.getDataSourceInfo(tenantId, true);
            }
            catch (UnknownTenant unknownTenant) {
                freshInfo = null;
            }
            if (freshInfo == null) {
                this.adjustCacheAfterTenantDeletion(tenantId);
                logger.debug("Tenant was deleted");
                throw new InternalError("Tenant was deleted");
            }
            if (!this.credentialsChanged(cachedInfo, freshInfo)) {
                logger.debug("Normal database error");
                throw new InternalError("Normal database error");
            }
            this.adjustCacheAfterCredentialChange(tenantId, dataSourceAndInfo, freshInfo);
        }
    }

    private void adjustCacheAfterCredentialChange(String tenantId, DataSourceAndInfo dataSourceAndInfo, DataSourceInfo currentInfo) {
        if (!(this.combinePools && StringUtils.equals((CharSequence)dataSourceAndInfo.getDataSourceInfo().getDatabaseId(), (CharSequence)currentInfo.getDatabaseId()) && StringUtils.equals((CharSequence)dataSourceAndInfo.getDataSourceInfo().getDbKey(), (CharSequence)currentInfo.getDbKey()))) {
            this.deleteFromCache(tenantId);
        } else {
            dataSourceAndInfo.setDataSourceInfo(currentInfo);
        }
    }

    private boolean credentialsChanged(DataSourceInfo cached, DataSourceInfo current) {
        return !StringUtils.equals((CharSequence)current.getPassword(), (CharSequence)cached.getPassword()) || !StringUtils.equals((CharSequence)current.getUser(), (CharSequence)cached.getUser()) || !StringUtils.equals((CharSequence)current.getSchema(), (CharSequence)cached.getSchema()) || !StringUtils.equals((CharSequence)current.getDbKey(), (CharSequence)cached.getDbKey());
    }

    private void adjustCacheAfterTenantDeletion(String tenantId) {
        if (!this.combinePools) {
            this.deleteFromCache(tenantId);
        } else {
            this.tenantToDataSource.remove(tenantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFromCache(String tenantId) {
        if (tenantId == null) {
            return;
        }
        logger.debug("Instance for tenant {} deleted from cache", (Object)tenantId);
        TenantMutex tenantMutex = TenantMutexFactory.get(tenantId);
        synchronized (tenantMutex) {
            DataSourceAndInfo dataSourceAndInfo = this.tenantToDataSource.get(tenantId);
            if (dataSourceAndInfo == null) {
                return;
            }
            this.tenantToDataSource.remove(tenantId);
            if (this.combinePools) {
                long numberOfEntries = this.tenantToDataSource.entrySet().stream().filter(e -> ((DataSourceAndInfo)e.getValue()).getDataSource() == dataSourceAndInfo.getDataSource()).count();
                if (numberOfEntries == 0L) {
                    this.libContainerCache.remove(dataSourceAndInfo.getDataSourceInfo().getDbKey());
                    this.closeDataSource(dataSourceAndInfo.getDataSource());
                }
            } else {
                this.closeDataSource(dataSourceAndInfo.getDataSource());
            }
        }
    }

    public void reset() {
        if (this.combinePools) {
            this.tenantToDataSource.clear();
            this.libContainerCache.reset();
        } else {
            this.tenantToDataSource.entrySet().stream().forEach(e -> this.closeDataSource(((DataSourceAndInfo)e.getValue()).getDataSource()));
            this.tenantToDataSource.clear();
        }
    }

    public List<HealthCheckResult> checkDataSourcePerDb(String dummySelectStatement) {
        ArrayList<HealthCheckResult> result = new ArrayList<HealthCheckResult>();
        try {
            this.instanceLifecycleManager.getLibContainers().stream().forEach(this::createAndCachePoolsForLibContainerPools);
        }
        catch (InternalError e2) {
            logger.error("Could not access containers owned by the mt-lib", (Throwable)e2);
            HealthCheckResult healthCheckResult = new HealthCheckResult("", false, e2);
            result.add(healthCheckResult);
            return result;
        }
        this.libContainerCache.stream().forEach(e -> {
            try (Connection connection = ((DataSource)e.getValue()).getConnection();){
                SqlOperations sqlOperations = SqlOperations.build(this.instanceLifecycleManager.getDbType());
                sqlOperations.setDummySelectStatement(dummySelectStatement);
                sqlOperations.dummySelect(connection);
                HealthCheckResult healthCheckResult = new HealthCheckResult((String)e.getKey(), true, null);
                result.add(healthCheckResult);
            }
            catch (InternalError | SQLException exception) {
                HealthCheckResult healthCheckResult = new HealthCheckResult((String)e.getKey(), false, exception);
                result.add(healthCheckResult);
            }
        });
        return result;
    }

    boolean doesTenantExist(String tenantId) throws InternalError {
        try {
            this.instanceLifecycleManager.checkThatTenantExists(tenantId);
            return true;
        }
        catch (UnknownTenant unknownTenant) {
            return false;
        }
    }

    protected abstract DataSource create(DataSourceInfo var1) throws InternalError;

    protected abstract void closeDataSource(DataSource var1);

    public boolean isCombinePools() {
        return this.combinePools;
    }

    public PoolMode poolMode() {
        if (this.combinePools) {
            return PoolMode.POOL_PER_DB_CREDENTIALS_PER_TENANT;
        }
        return PoolMode.POOL_AND_CREDENTIALS_PER_TENANT;
    }

    public DbIdentifiers.DB getDbType() {
        return this.instanceLifecycleManager.getDbType();
    }

    public boolean healthCheckPossible() {
        try {
            return !this.instanceLifecycleManager.getLibContainers().isEmpty();
        }
        catch (InternalError e) {
            return false;
        }
    }

    private class LibContainerCache {
        private final ConcurrentHashMap<String, DataSource> dbKeyToLibContainer = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, DataSourceInfo> dbKeyToLibContainerInfo = new ConcurrentHashMap();

        private LibContainerCache() {
        }

        private boolean isContained(String dbKey) {
            return this.dbKeyToLibContainer.containsKey(dbKey);
        }

        private DataSource get(String dbKey) {
            return this.dbKeyToLibContainer.get(dbKey);
        }

        private DataSourceInfo getInfo(String dbKey) {
            return this.dbKeyToLibContainerInfo.get(dbKey);
        }

        private DataSource remove(String dbKey) {
            this.dbKeyToLibContainerInfo.remove(dbKey);
            return this.dbKeyToLibContainer.remove(dbKey);
        }

        private void reset() {
            this.dbKeyToLibContainer.entrySet().stream().forEach(e -> DataSourceLookup.this.closeDataSource((DataSource)e.getValue()));
            this.dbKeyToLibContainer.clear();
            this.dbKeyToLibContainerInfo.clear();
        }

        private Stream<Map.Entry<String, DataSource>> stream() {
            return this.dbKeyToLibContainer.entrySet().stream();
        }

        private void createIfNotExist(String dbKey, MtxTools.SupplierWithInternalError<DataSource> dataSourceSupplier, DataSourceInfo dataSourceInfo) {
            try {
                this.dbKeyToLibContainerInfo.putIfAbsent(dbKey, dataSourceInfo);
                this.dbKeyToLibContainer.putIfAbsent(dbKey, dataSourceSupplier.get());
            }
            catch (InternalError e) {
                logger.error("Cannot create data source pool", (Throwable)e);
            }
        }
    }
}

