/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.lib.runtime.IdentityZoneDeterminer;
import com.sap.cds.feature.mt.lib.runtime.TenantOverwrite;
import com.sap.cds.feature.mt.lib.subscription.exceptions.MtLibError;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantProvider
implements Supplier<String> {
    private static Logger logger = LoggerFactory.getLogger(TenantProvider.class);
    private final IdentityZoneDeterminer determiner;

    public TenantProvider(IdentityZoneDeterminer determiner) {
        this.determiner = determiner;
    }

    @Override
    public String get() {
        try {
            if (TenantOverwrite.isOverwritten()) {
                logger.debug("Tenant overwrite is active");
                return TenantOverwrite.getTenantId();
            }
            String tenantId = this.determiner.getIdentityZone();
            logger.debug("Tenant id {} determined", (Object)tenantId);
            return tenantId;
        }
        catch (InternalError e) {
            logger.error("Could not determine tenant ID");
            throw new MtLibError(e);
        }
    }
}

