/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.DbCredentials;
import com.sap.cds.feature.mt.lib.subscription.DbIdentifiers;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class DbCredentialsH2
extends DbCredentials {
    private static final String ORG_H2_DRIVER = "org.h2.Driver";
    private final String database;
    private final String h2PackageVersion = DbCredentialsH2.getH2PackageVersion();

    public DbCredentialsH2(String user, String password, String database) throws InternalError {
        super(user, password, "", "", ORG_H2_DRIVER, "");
        this.database = database;
    }

    public DbCredentialsH2(DbCredentialsH2 dbCredentials) {
        super(dbCredentials);
        this.database = dbCredentials.database;
    }

    @Override
    public String getDatabaseId() {
        return this.database;
    }

    @Override
    protected String buildUrl() {
        if (this.h2PackageVersion.startsWith("1.")) {
            return "jdbc:h2:mem:" + this.database + ";DB_CLOSE_DELAY=-1;DATABASE_TO_LOWER=TRUE;CASE_INSENSITIVE_IDENTIFIERS=TRUE;";
        }
        return "jdbc:h2:mem:" + this.database + ";DB_CLOSE_DELAY=-1;COLLATION=DEFAULT_EN STRENGTH PRIMARY;";
    }

    @Override
    public DbIdentifiers.DB getDB() {
        return DbIdentifiers.DB.H2;
    }

    @Override
    public DbCredentials createCopy() {
        return new DbCredentialsH2(this);
    }

    @Override
    protected List<DbCredentials.HostAndPort> getHostsFromUri(URI uri) {
        return new ArrayList<DbCredentials.HostAndPort>();
    }

    @Override
    protected DbCredentials.UserAndPassword getUserFromUri(URI uri) {
        return new DbCredentials.UserAndPassword();
    }

    static String getH2PackageVersion() {
        try {
            Class<?> c = Class.forName(ORG_H2_DRIVER);
            return c.getPackage().getImplementationVersion();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class org.h2.Driver not available");
        }
    }
}

