/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import com.sap.cds.feature.mt.lib.subscription.DbDeployer;
import com.sap.cds.feature.mt.lib.subscription.FilterTenants;
import com.sap.cds.feature.mt.lib.subscription.ServiceSpecification;
import com.sap.cds.feature.mt.lib.subscription.exceptions.HdiDeploymentCommunicationProblem;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.exits.UserProvidedSchemasExit;
import com.sap.cds.feature.mt.lib.subscription.json.AsyncDeploymentReturn;
import com.sap.cds.feature.mt.lib.subscription.json.Credentials;
import com.sap.cds.feature.mt.lib.subscription.json.DbHost;
import com.sap.cds.feature.mt.lib.subscription.json.DeploymentPayload;
import com.sap.cds.feature.mt.lib.subscription.json.DeploymentReturn;
import com.sap.cds.feature.mt.lib.subscription.json.Hana;
import com.sap.cds.feature.mt.lib.subscription.json.ImBasedCredentialsHdiDeployment;
import com.sap.cds.feature.mt.lib.subscription.json.ImBasedHdiDeploymentPayload;
import com.sap.cds.feature.mt.lib.subscription.json.UserProvidedSchema;
import com.sap.cds.feature.mt.lib.subscription.json.VcapService;
import com.sap.cds.services.utils.lib.tools.api.ServiceCall;
import com.sap.cds.services.utils.lib.tools.api.ServiceEndpoint;
import com.sap.cds.services.utils.lib.tools.api.ServiceResponse;
import com.sap.cds.services.utils.lib.tools.exception.InternalException;
import com.sap.cds.services.utils.lib.tools.exception.ServiceException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class HdiContainerManager
implements DbDeployer {
    public static final String HDI_DEPLOYER_DESTINATION = "com.sap.cds.mtHdiDynamicDeployer";
    public static final String TARGET_CONTAINER_NAME = "COMSAPICDMTHDI";
    private static final Logger logger = LoggerFactory.getLogger(HdiContainerManager.class);
    private static final String DEPLOY_SYNC_PATH = "/v1/deploy";
    private static final String DEPLOY_ASYNC_PATH = "/v1/deploy/to/instance/async";
    private static final String STATUS_PATH = "/v1/status/";
    private static final String DEPLOYMENT_ENDPOINT_RETURNED = "HDI deployment endpoint returned http response code {}";
    private static final String DEPLOYMENT_RETURNED_AN_ERROR = "HDI deployment returned an error";
    private static final String HDI_DEPLOYMENT_FAILED_FOR_JOB_ID_IT_RETURNED_AN_EMPTY_PAYLOAD = "HDI deployment failed for job-id {}. It returned an empty payload";
    private static final String FINISHED = "FINISHED";
    private static final String HDI_DEPLOYMENT_RETURNED_NO_PAYLOAD = "HDI deployment returned no payload";
    private static final String HDI_DEPLOYMENT_RETURNED_WITH_EXIT_CODE_BUT_NO_RETURN_MESSAGES_PROVIDED = "HDI deployment returned with exit code {}, but no return messages provided";
    private static final String ERROR = "ERROR";
    private static final String PATH_MESSAGE = "Path: {} .Message {} ";
    private static final String ASYNCHRONOUS_HDI_DEPLOYMENT_DIDN_T_RETURN_A_JOB_GUID = "Asynchronous HDI deployment didn't return a job-id";
    private static final String HDI_DEPLOYMENT_SUCCEEDED = "HDI deployment succeeded for tenant {}";
    private static final String DYNAMIC_DEPLOYER_WAS_TRIGGERED_FOR_TENANT_AND_JOB_ID = "HDI deployment was triggered for tenant {} and job-id {}";
    private static final String DEPLOYMENT_DIDN_T_FINISH_IN_MAXIMUM_TIME = "HDI deployment didn't finish in maximum time {}";
    public static final String FAILED = "FAILED";
    public static final String RUNNING = "RUNNING";
    private final UserProvidedSchemasExit userProvidedSchemasExit;
    private final ServiceEndpoint deployEndpoint;
    private final ServiceEndpoint asyncDeployEndpoint;
    private final ServiceEndpoint statusEndpoint;
    private final ServiceSpecification serviceSpecification;

    public HdiContainerManager(ServiceSpecification serviceSpecification, UserProvidedSchemasExit userProvidedSchemasExit) throws InternalError {
        this.serviceSpecification = serviceSpecification;
        this.userProvidedSchemasExit = userProvidedSchemasExit;
        HashSet<Integer> retryCodes = new HashSet<Integer>();
        retryCodes.add(502);
        retryCodes.add(504);
        retryCodes.add(500);
        retryCodes.add(503);
        retryCodes.add(404);
        try {
            this.deployEndpoint = ServiceEndpoint.create().destinationName(HDI_DEPLOYER_DESTINATION).path(DEPLOY_SYNC_PATH).returnCodeChecker(c -> {
                if (c != 200) {
                    return new HdiDeploymentCommunicationProblem(MessageFormatter.format((String)DEPLOYMENT_ENDPOINT_RETURNED, (Object)c).getMessage());
                }
                return null;
            }).retry().forReturnCodes(retryCodes).config(serviceSpecification.getResilienceConfig()).end();
            this.asyncDeployEndpoint = ServiceEndpoint.create().destinationName(HDI_DEPLOYER_DESTINATION).path(DEPLOY_ASYNC_PATH).returnCodeChecker(c -> {
                if (c != 200 && c != 201) {
                    return new HdiDeploymentCommunicationProblem(MessageFormatter.format((String)DEPLOYMENT_ENDPOINT_RETURNED, (Object)c).getMessage());
                }
                return null;
            }).retry().forReturnCodes(retryCodes).config(serviceSpecification.getResilienceConfig()).end();
            this.statusEndpoint = ServiceEndpoint.create().destinationName(HDI_DEPLOYER_DESTINATION).path(STATUS_PATH).returnCodeChecker(c -> {
                if (c != 200) {
                    return new HdiDeploymentCommunicationProblem(MessageFormatter.format((String)DEPLOYMENT_ENDPOINT_RETURNED, (Object)c).getMessage());
                }
                return null;
            }).retry().forReturnCodes(retryCodes).config(serviceSpecification.getResilienceConfig()).end();
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
    }

    private static void waitSomeTime(Duration waitTime) {
        try {
            Thread.sleep(waitTime.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void populate(DataSourceInfo dataSourceInfo, String tenantId) throws InternalError {
        if (!FilterTenants.realTenants().test(tenantId)) {
            return;
        }
        try {
            if (this.userProvidedSchemasExit != null) {
                this.populateHdiContainerSync(dataSourceInfo, tenantId);
            } else {
                String jobGuid = this.populateHdiContainerAsync(dataSourceInfo);
                logger.debug(DYNAMIC_DEPLOYER_WAS_TRIGGERED_FOR_TENANT_AND_JOB_ID, (Object)tenantId, (Object)jobGuid);
                Instant start = Instant.now();
                boolean finished = false;
                do {
                    HdiContainerManager.waitSomeTime(this.serviceSpecification.getPolling().getInterval());
                } while (!(finished = this.isDeploymentFinishedInternal(jobGuid)) && Duration.between(start, Instant.now()).compareTo(this.serviceSpecification.getPolling().getRequestTimeout()) <= 0);
                if (!finished) {
                    logger.error(DEPLOYMENT_DIDN_T_FINISH_IN_MAXIMUM_TIME, (Object)this.serviceSpecification.getPolling().getRequestTimeout());
                    throw new InternalError(MessageFormatter.format((String)DEPLOYMENT_DIDN_T_FINISH_IN_MAXIMUM_TIME, (Object)this.serviceSpecification.getPolling().getRequestTimeout()).getMessage());
                }
            }
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    private void populateHdiContainerSync(DataSourceInfo dataSourceInfo, String tenantId) throws InternalError, HdiDeploymentCommunicationProblem {
        ServiceResponse response = null;
        try {
            ServiceCall deploy = this.deployEndpoint.createServiceCall().http().post().payload((Object)this.getBody(dataSourceInfo, this.userProvidedSchemasExit.onCallDynamicHdiDeployment())).noPathParameter().noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).end();
            response = deploy.execute(DeploymentReturn.class);
        }
        catch (ServiceException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof HdiDeploymentCommunicationProblem) {
                HdiDeploymentCommunicationProblem cause = (HdiDeploymentCommunicationProblem)throwable;
                throw cause;
            }
            throw new InternalError(e);
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        DeploymentReturn deploymentReturn = response.getPayload().orElse(null);
        if (deploymentReturn == null || deploymentReturn.exitCode == null || deploymentReturn.exitCode != 0) {
            logger.error(DEPLOYMENT_RETURNED_AN_ERROR);
            this.writeDeployReturnIntoLog(deploymentReturn);
            throw new InternalError(DEPLOYMENT_RETURNED_AN_ERROR);
        }
        logger.debug(HDI_DEPLOYMENT_SUCCEEDED, (Object)tenantId);
    }

    private String populateHdiContainerAsync(DataSourceInfo dataSourceInfo) throws InternalError, HdiDeploymentCommunicationProblem {
        ServiceResponse response = null;
        try {
            ServiceCall deploy = this.asyncDeployEndpoint.createServiceCall().http().post().payload((Object)this.getBodyWithInstanceManagerBasedPayload(dataSourceInfo)).noPathParameter().noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).end();
            response = deploy.execute(AsyncDeploymentReturn.class);
        }
        catch (ServiceException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof HdiDeploymentCommunicationProblem) {
                HdiDeploymentCommunicationProblem cause = (HdiDeploymentCommunicationProblem)throwable;
                throw cause;
            }
            throw new InternalError(e);
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        AsyncDeploymentReturn deploymentReturn = response.getPayload().orElse(null);
        if (deploymentReturn == null || deploymentReturn.guid == null || deploymentReturn.guid.isEmpty()) {
            throw new InternalError(ASYNCHRONOUS_HDI_DEPLOYMENT_DIDN_T_RETURN_A_JOB_GUID);
        }
        return deploymentReturn.guid;
    }

    public boolean isDeploymentFinishedInternal(String jobGuid) throws InternalError, HdiDeploymentCommunicationProblem {
        ServiceResponse response = null;
        try {
            ServiceCall status = this.statusEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(new String[]{jobGuid}).noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).end();
            response = status.execute(DeploymentReturn.class);
        }
        catch (ServiceException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof HdiDeploymentCommunicationProblem) {
                HdiDeploymentCommunicationProblem cause = (HdiDeploymentCommunicationProblem)throwable;
                throw cause;
            }
            throw new InternalError(e);
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        DeploymentReturn deploymentReturn = response.getPayload().orElse(null);
        if (deploymentReturn != null) {
            if (FINISHED.equalsIgnoreCase(deploymentReturn.status)) {
                return true;
            }
            if (FAILED.equalsIgnoreCase(deploymentReturn.status)) {
                this.writeDeployReturnIntoLog(deploymentReturn);
                throw new InternalError("Hdi deployment failed");
            }
            if (RUNNING.equalsIgnoreCase(deploymentReturn.status)) {
                return false;
            }
            throw new InternalError("Wrong or missing status %s from HDI deployer".formatted(deploymentReturn.status));
        }
        logger.error(HDI_DEPLOYMENT_FAILED_FOR_JOB_ID_IT_RETURNED_AN_EMPTY_PAYLOAD, (Object)jobGuid);
        throw new HdiDeploymentCommunicationProblem(MessageFormatter.format((String)HDI_DEPLOYMENT_FAILED_FOR_JOB_ID_IT_RETURNED_AN_EMPTY_PAYLOAD, (Object)jobGuid).getMessage());
    }

    protected DeploymentPayload getBody(DataSourceInfo dataSourceInfo, List<UserProvidedSchema> userProvidedSchemas) {
        DeploymentPayload payload = new DeploymentPayload();
        DbHost[] dbHosts = new DbHost[]{new DbHost()};
        dbHosts[0].port = Integer.parseInt(dataSourceInfo.getPort());
        dbHosts[0].host = dataSourceInfo.getHost();
        Credentials credentials = new Credentials();
        credentials.schema = dataSourceInfo.getSchema();
        credentials.driver = dataSourceInfo.getDriver();
        credentials.port = dataSourceInfo.getPort();
        credentials.host = dataSourceInfo.getHost();
        credentials.db_hosts = dbHosts;
        credentials.user = dataSourceInfo.getUser();
        credentials.password = dataSourceInfo.getPassword();
        credentials.hdi_user = dataSourceInfo.getHdiUser();
        credentials.hdi_password = dataSourceInfo.getHdiPassword();
        credentials.url = dataSourceInfo.getUrl();
        credentials.certificate = dataSourceInfo.getCertificate();
        Hana[] hanas = new Hana[]{new Hana()};
        hanas[0].name = TARGET_CONTAINER_NAME;
        hanas[0].credentials = credentials;
        payload.ADDITIONAL_VCAP_SERVICES = new VcapService();
        payload.ADDITIONAL_VCAP_SERVICES.hana = hanas;
        if (userProvidedSchemas != null && !userProvidedSchemas.isEmpty()) {
            UserProvidedSchema[] userProvidedSchemaArray = new UserProvidedSchema[userProvidedSchemas.size()];
            userProvidedSchemas.toArray(userProvidedSchemaArray);
            payload.ADDITIONAL_VCAP_SERVICES.user_provided = userProvidedSchemaArray;
        }
        payload.TARGET_CONTAINER = TARGET_CONTAINER_NAME;
        return payload;
    }

    private ImBasedHdiDeploymentPayload getBodyWithInstanceManagerBasedPayload(DataSourceInfo dataSourceInfo) {
        ImBasedCredentialsHdiDeployment credentials;
        ImBasedHdiDeploymentPayload payload = new ImBasedHdiDeploymentPayload();
        payload.credentials = credentials = new ImBasedCredentialsHdiDeployment();
        credentials.schema = dataSourceInfo.getSchema();
        credentials.driver = dataSourceInfo.getDriver();
        credentials.port = dataSourceInfo.getPort();
        credentials.host = dataSourceInfo.getHost();
        credentials.user = dataSourceInfo.getUser();
        credentials.password = dataSourceInfo.getPassword();
        credentials.hdi_user = dataSourceInfo.getHdiUser();
        credentials.hdi_password = dataSourceInfo.getHdiPassword();
        credentials.url = dataSourceInfo.getUrl();
        credentials.certificate = dataSourceInfo.getCertificate();
        payload.tenant_id = dataSourceInfo.getTenantId();
        payload.id = dataSourceInfo.getId();
        payload.status = dataSourceInfo.getStatusAsText();
        return payload;
    }

    private void writeDeployReturnIntoLog(DeploymentReturn deploymentReturn) {
        if (deploymentReturn == null || deploymentReturn.messages == null) {
            if (deploymentReturn == null) {
                logger.error(HDI_DEPLOYMENT_RETURNED_NO_PAYLOAD);
            } else {
                logger.error(HDI_DEPLOYMENT_RETURNED_WITH_EXIT_CODE_BUT_NO_RETURN_MESSAGES_PROVIDED, (Object)deploymentReturn.exitCode);
            }
            return;
        }
        Arrays.stream(deploymentReturn.messages).filter(m -> ERROR.equalsIgnoreCase(m.severity)).forEach(m -> logger.error(PATH_MESSAGE, (Object)m.path, (Object)m.message));
    }
}

