/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import java.time.Duration;

public class PollingParameters {
    public static final PollingParameters DEFAULT = Builder.create().interval(Duration.ofSeconds(10L)).timeout(Duration.ofMinutes(10L)).build();
    private Duration interval;
    private Duration requestTimeout;

    private PollingParameters() {
    }

    public Duration getInterval() {
        return this.interval;
    }

    public void setInterval(Duration interval) {
        this.interval = interval;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public static final class Builder {
        private Duration interval = Duration.ofSeconds(5L);
        private Duration timeout = Duration.ofMinutes(10L);

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder interval(Duration interval) {
            this.interval = interval;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public PollingParameters build() {
            PollingParameters pollingParameters = new PollingParameters();
            pollingParameters.setInterval(this.interval);
            pollingParameters.setRequestTimeout(this.timeout);
            return pollingParameters;
        }
    }
}

