/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.sap.cds.feature.mt.lib.subscription.HanaEncryptionTool;
import com.sap.cds.feature.mt.lib.subscription.PollingParameters;
import com.sap.cds.feature.mt.lib.subscription.SecurityChecker;
import com.sap.cds.feature.mt.lib.subscription.ServiceCreateOptions;
import com.sap.cds.feature.mt.lib.subscription.SubscriptionPayloadAccess;
import com.sap.cds.feature.mt.lib.subscription.Tools;
import com.sap.cds.feature.mt.lib.subscription.exceptions.AuthorityError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.NotFound;
import com.sap.cds.feature.mt.lib.subscription.exceptions.ParameterError;
import com.sap.cds.feature.mt.lib.subscription.exits.Exits;
import com.sap.cds.feature.mt.lib.subscription.json.DeletePayload;
import com.sap.cds.feature.mt.lib.subscription.json.SubscriptionPayload;
import com.sap.cds.services.utils.lib.tools.api.AsyncCallResult;
import com.sap.cds.services.utils.lib.tools.api.ServiceResponse;
import com.sap.cds.services.utils.lib.tools.exception.InternalException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtxTools {
    private static final String X_JOB_ID = "x-job-id";
    private static final String LOCATION = "Location";
    private static Logger logger = LoggerFactory.getLogger(MtxTools.class);
    private static final String STATUS = "status";
    private static final String JOB_ID = "jobID";
    private final SecurityChecker securityChecker;
    private final String baseUiUrl;
    private final String urlSeparator;
    private final PollingParameters pollingParameter;
    private final HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode;
    private static final ObjectMapper mapper = new ObjectMapper();

    public MtxTools(SecurityChecker securityChecker, String baseUiUrl, String urlSeparator, PollingParameters pollingParameter, HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode) {
        this.securityChecker = securityChecker;
        this.baseUiUrl = baseUiUrl;
        this.urlSeparator = urlSeparator;
        this.pollingParameter = pollingParameter;
        this.hanaEncryptionMode = hanaEncryptionMode;
    }

    public static AsyncCallResult waitForCompletion(String jobId, StatusProvider statusProvider, PollingParameters pollingParameter) {
        Instant start = Instant.now();
        while (true) {
            logger.debug("Wait for completion of job {}", (Object)jobId);
            try {
                Map<String, Object> result = statusProvider.getStatus(jobId);
                if (StringUtils.isBlank((CharSequence)((String)result.get(STATUS)))) {
                    String resultStr = mapper.writeValueAsString(result);
                    logger.error("Mtx returned no status for job {}. Mtx returned {}", (Object)jobId, (Object)resultStr);
                    return new AsyncCallResult((Exception)new InternalError("Mtx returned no status for job %s. Mtx returned %s".formatted(jobId, resultStr)));
                }
                logger.debug("Mtx returned status {} for job {}", result.get(STATUS), (Object)jobId);
                switch (((String)result.get(STATUS)).toUpperCase(Locale.ENGLISH)) {
                    case "FINISHED": {
                        return AsyncCallResult.createOk();
                    }
                    case "INITIAL": 
                    case "QUEUED": 
                    case "RUNNING": 
                    case "PROCESSING": {
                        break;
                    }
                    case "FAILED": {
                        return new AsyncCallResult((Exception)new InternalError("Provisioning service returned with status \"failed\". Mtx returned %s".formatted(mapper.writeValueAsString(result))));
                    }
                    default: {
                        return new AsyncCallResult((Exception)new InternalError("Unexpected status %s. Mtx returned %s".formatted(result.get(STATUS), mapper.writeValueAsString(result))));
                    }
                }
            }
            catch (Exception e) {
                return new AsyncCallResult(e);
            }
            if (Duration.between(start, Instant.now()).compareTo(pollingParameter.getRequestTimeout()) >= 0) {
                logger.error("Maximum waiting time for job {} exceeded", (Object)jobId);
                return new AsyncCallResult((Exception)new InternalError("Maximum waiting time on called service exceeded"));
            }
            Tools.waitSomeTime(pollingParameter.getInterval());
        }
    }

    public static String extractJobId(ServiceResponse<String> response) throws InternalException {
        String jobId = null;
        if (response.getHeaders() != null) {
            jobId = MtxTools.getFromHeader(response, X_JOB_ID);
            if (StringUtils.isNotBlank((CharSequence)jobId)) {
                return jobId;
            }
            String location = MtxTools.getFromHeader(response, LOCATION);
            String[] parts = location.split("/jobs/");
            if (parts.length == 2 && StringUtils.isNotBlank((CharSequence)(jobId = parts[1]))) {
                if (jobId.startsWith("pollJob(")) {
                    throw new InternalException("The header x-job-id wasn't set");
                }
                return jobId;
            }
        }
        if (StringUtils.isBlank((CharSequence)(jobId = (String)MtxTools.getResponseAsMap(response).get(JOB_ID)))) {
            throw new InternalException("No job id returned");
        }
        logger.debug("Returned jobId is {}", (Object)jobId);
        return jobId;
    }

    private static String getFromHeader(ServiceResponse<String> response, String fieldName) {
        return Arrays.stream(response.getHeaders()).filter(h -> h.getName().equalsIgnoreCase(fieldName)).map(NameValuePair::getValue).findFirst().orElse("");
    }

    private static Map<String, Object> getResponseAsMap(ServiceResponse<String> response) throws InternalException {
        if (response.getPayload().isPresent()) {
            try {
                return (Map)new Gson().fromJson((String)response.getPayload().get(), Map.class);
            }
            catch (JsonSyntaxException e) {
                throw new InternalException("No map returned from mtx service", (Throwable)e);
            }
        }
        return new HashMap<String, Object>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unsubscribe(String tenantId, UnSubscribeExecutor unsubscribeExecutor, StatusProvider statusProvider, DeletePayload deletePayload, boolean withoutAuthorityCheck, Exits exits) throws InternalError, ParameterError, AuthorityError {
        if (!withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        Tools.checkExternalTenantId(tenantId);
        boolean isUnsubscribePossible = Boolean.TRUE.equals(exits.getBeforeUnSubscribeMethod().call(tenantId, deletePayload));
        if (isUnsubscribePossible) {
            String jobId = unsubscribeExecutor.execute();
            AsyncCallResult asyncCallResult = MtxTools.waitForCompletion(jobId, statusProvider, this.pollingParameter);
            if (!asyncCallResult.isOk()) throw new InternalError(asyncCallResult.getException());
            exits.getAfterUnSubscribeMethod().call(tenantId, deletePayload);
            return;
        } else {
            logger.debug("Unsubscribe exit returned false => skipped unsubscribe for tenant {}", (Object)tenantId);
        }
    }

    public String subscribe(String tenantId, SubscribeExecutor subscribeExecutor, StatusProvider statusProvider, SubscriptionPayload subscriptionPayload, boolean withoutAuthorityCheck, Exits exits) throws InternalError, ParameterError, AuthorityError {
        String jobId;
        if (!withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        Tools.checkExternalTenantId(tenantId);
        ServiceCreateOptions serviceCreateOptions = new ServiceCreateOptions(exits.getBeforeSubscribeMethod().call(tenantId, subscriptionPayload));
        SubscriptionPayloadAccess payloadAccess = SubscriptionPayloadAccess.create(subscriptionPayload.getMap());
        HanaEncryptionTool.addEncryptionParameter(serviceCreateOptions, this.hanaEncryptionMode, payloadAccess);
        String applicationUrl = Tools.getApplicationUrl(subscriptionPayload, exits.getSubscribeExit()::uiURL, exits.getSubscribeExit()::uiURL, this.baseUiUrl, this.urlSeparator);
        try {
            jobId = subscribeExecutor.execute(serviceCreateOptions);
        }
        catch (InternalError e) {
            exits.getAfterSubscribeMethod().call(tenantId, subscriptionPayload, false);
            throw e;
        }
        AsyncCallResult asyncCallResult = MtxTools.waitForCompletion(jobId, statusProvider, this.pollingParameter);
        exits.getAfterSubscribeMethod().call(tenantId, subscriptionPayload, asyncCallResult.isOk());
        if (asyncCallResult.isNotOk()) {
            throw new InternalError(asyncCallResult.getException());
        }
        return applicationUrl;
    }

    @FunctionalInterface
    public static interface StatusProvider {
        public Map<String, Object> getStatus(String var1) throws InternalError, NotFound;
    }

    @FunctionalInterface
    public static interface UnSubscribeExecutor {
        public String execute() throws InternalError;
    }

    @FunctionalInterface
    public static interface SubscribeExecutor {
        public String execute(ServiceCreateOptions var1) throws InternalError;
    }

    @FunctionalInterface
    public static interface SupplierWithInternalError<T> {
        public T get() throws InternalError;
    }

    @FunctionalInterface
    public static interface SaasRegistryCaller {
        public void callSaasRegistry(boolean var1, String var2, String var3) throws InternalError;
    }
}

