/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.runtime;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class DataPoolSettings {
    private final Map<ConnectionPoolType, ParameterList> parameterLists = new EnumMap<ConnectionPoolType, ParameterList>(ConnectionPoolType.class);

    public DataPoolSettings(Map<String, ConnectionPoolType> prefixToPoolType) {
        for (ConnectionPoolType type : ConnectionPoolType.values()) {
            this.parameterLists.put(type, type.createParameterList());
        }
        for (Map.Entry entry : prefixToPoolType.entrySet()) {
            String prefix = (String)entry.getKey();
            this.parameterLists.get(entry.getValue()).initList(prefix);
        }
    }

    public Stream<Parameter> getHikariParameters() {
        return this.parameterLists.get((Object)ConnectionPoolType.HIKARI).stream();
    }

    public Stream<Parameter> getTomcatParameters() {
        return this.parameterLists.get((Object)ConnectionPoolType.TOMCAT).stream();
    }

    private static List<Parameter> generateParameterList(String prefix, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Method[] methods = clazz.getDeclaredMethods();
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            Arrays.stream(methods).filter(method -> Modifier.isPublic(method.getModifiers())).forEach(method -> {
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length == 1) {
                    if (method.getName().startsWith("set")) {
                        parameters.add(new Parameter(DataPoolSettings.getParameterName(method.getName().substring(3)), paramTypes[0], prefix));
                    }
                    if (method.getName().startsWith("is")) {
                        parameters.add(new Parameter(DataPoolSettings.getParameterName(method.getName().substring(2)), paramTypes[0], prefix));
                    }
                }
            });
            return parameters;
        }
        catch (ClassNotFoundException e) {
            return new ArrayList<Parameter>();
        }
    }

    private static String getParameterName(String parameterName) {
        String firstChar = parameterName.length() > 0 ? Character.valueOf(Character.toLowerCase(parameterName.charAt(0))) : "";
        String rest = parameterName.length() > 1 ? parameterName.substring(1) : "";
        return (Serializable)((Object)firstChar) + rest;
    }

    public static String normalizedName(String name) {
        if (name == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char current = name.charAt(i);
            if (Character.isUpperCase(current)) {
                if (i != 0) {
                    stringBuilder.append("-");
                }
                stringBuilder.append(Character.toLowerCase(current));
                continue;
            }
            stringBuilder.append(current);
        }
        return stringBuilder.toString();
    }

    public static enum ConnectionPoolType {
        HIKARI(HikariParameterList::new),
        TOMCAT(TomcatParameterList::new);

        private final Supplier<ParameterList> paramListSupplier;

        private ConnectionPoolType(Supplier<ParameterList> paramListSupplier) {
            this.paramListSupplier = paramListSupplier;
        }

        ParameterList createParameterList() {
            return this.paramListSupplier.get();
        }
    }

    public static interface ParameterList
    extends List<Parameter> {
        public void initList(String var1);
    }

    public static class Parameter {
        private final String name;
        private final Class<?> type;
        private final String prefix;

        private Parameter(String name, Class<?> type, String prefix) {
            this.name = name;
            this.type = type;
            this.prefix = prefix;
        }

        public String getNameInEnv() {
            return (String)(this.prefix.isBlank() ? "" : this.prefix + ".") + this.name;
        }

        public String getNormalizedNameInEnv() {
            return (String)(this.prefix.isBlank() ? "" : this.prefix + ".") + DataPoolSettings.normalizedName(this.name);
        }

        public String getPoolPropertyName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getSetterName() {
            return "set" + this.name.substring(0, 1).toUpperCase(Locale.ENGLISH) + this.name.substring(1);
        }

        public String getGetterName() {
            return "get" + this.name.substring(0, 1).toUpperCase(Locale.ENGLISH) + this.name.substring(1);
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    private static class TomcatParameterList
    extends LinkedList<Parameter>
    implements ParameterList {
        private TomcatParameterList() {
        }

        @Override
        public void initList(String prefix) {
            List<String> forbidden = List.of("username", "password", "name", "url", "dataSource", "dataSourceJNDI", "driverClassName");
            DataPoolSettings.generateParameterList(prefix, "org.apache.tomcat.jdbc.pool.PoolConfiguration").stream().filter(p -> !forbidden.contains(p.getPoolPropertyName())).forEach(this::add);
        }
    }

    private static class HikariParameterList
    extends LinkedList<Parameter>
    implements ParameterList {
        private HikariParameterList() {
        }

        @Override
        public void initList(String prefix) {
            List<String> forbidden = List.of("jdbcUrl", "schema", "dataSourceClassName", "poolName", "password", "username", "dataSource", "dataSourceJNDI", "driverClassName");
            DataPoolSettings.generateParameterList(prefix, "com.zaxxer.hikari.HikariConfig").stream().filter(p -> !forbidden.contains(p.getPoolPropertyName())).forEach(this::add);
        }
    }
}

