/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.mt.lib.subscription.FilterTenants;
import com.sap.cds.feature.mt.lib.subscription.ServiceCreateOptions;
import com.sap.cds.feature.mt.lib.subscription.SubscriptionPayloadAccess;
import com.sap.cds.feature.mt.lib.subscription.UiUrlCreator;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.ParameterError;
import com.sap.cds.feature.mt.lib.subscription.json.Cloner;
import com.sap.cds.feature.mt.lib.subscription.json.SubscriptionPayload;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class Tools {
    public static final String SECURE_CHARS = "^[_a-zA-Z0-9\\-]+$";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String TENANT_SUCCESSFULLY_SUBSCRIBED_NO_APPLICATION_URL_PROVIDED = "tenant successfully subscribed - no application URL provided";
    public static final String ADDITIONAL_INFO_FOR_SM = "_";

    private Tools() {
    }

    public static void checkExternalTenantId(String tenantId) throws ParameterError {
        if (!FilterTenants.realTenants().test(tenantId)) {
            throw new ParameterError("Tenant Id is identical to a technical container");
        }
        Tools.checkTenantIdCharacters(tenantId);
    }

    public static void checkExternalTenantIds(List<String> tenantIds) throws ParameterError {
        for (String tenantId : tenantIds) {
            Tools.checkExternalTenantId(tenantId);
        }
    }

    public static void checkTenantIdCharacters(String tenantId) throws ParameterError {
        if (!tenantId.matches(SECURE_CHARS)) {
            throw new ParameterError("Tenant id contains forbidden characters");
        }
    }

    public static void waitSomeTime(Duration waitTime) {
        try {
            Thread.sleep(waitTime.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static String getApplicationUrl(SubscriptionPayload subscriptionPayload, Supplier<URL> urlSupplier, Function<SubscriptionPayload, URL> urlFunction, String baseUiUrl, String urlSeparator) throws InternalError {
        String applicationUrl;
        if (subscriptionPayload == null) {
            return TENANT_SUCCESSFULLY_SUBSCRIBED_NO_APPLICATION_URL_PROVIDED;
        }
        SubscriptionPayloadAccess payloadAccess = SubscriptionPayloadAccess.create(subscriptionPayload.getMap());
        if (StringUtils.isBlank((CharSequence)payloadAccess.getSubDomain())) {
            return TENANT_SUCCESSFULLY_SUBSCRIBED_NO_APPLICATION_URL_PROVIDED;
        }
        URL urlFromExit = urlSupplier.get();
        if (urlFromExit == null) {
            urlFromExit = urlFunction.apply(Cloner.clone(subscriptionPayload));
        }
        String string = applicationUrl = urlFromExit != null ? urlFromExit.toExternalForm() : null;
        if (applicationUrl == null) {
            applicationUrl = UiUrlCreator.createUrl(payloadAccess.getSubDomain(), baseUiUrl, urlSeparator);
        }
        if (StringUtils.isBlank((CharSequence)applicationUrl)) {
            applicationUrl = TENANT_SUCCESSFULLY_SUBSCRIBED_NO_APPLICATION_URL_PROVIDED;
        }
        return applicationUrl;
    }

    public static Map<String, Object> getProvisioningServicePayload(SubscriptionPayload subscriptionPayload, ServiceCreateOptions serviceCreateOptions) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.putAll(subscriptionPayload.getMap());
        boolean hasProvisioningParameters = false;
        boolean hasBindingParameters = false;
        if (serviceCreateOptions != null) {
            if (serviceCreateOptions.getProvisioningParameters() != null && !serviceCreateOptions.getProvisioningParameters().isEmpty()) {
                hasProvisioningParameters = true;
            }
            if (serviceCreateOptions.getBindingParameters() != null && !serviceCreateOptions.getBindingParameters().isEmpty()) {
                hasBindingParameters = true;
            }
        }
        if (hasProvisioningParameters || hasBindingParameters) {
            HashMap<String, Map<String, Object>> hdi = new HashMap<String, Map<String, Object>>();
            HashMap<String, HashMap<String, Map<String, Object>>> additionalInfoForSM = new HashMap<String, HashMap<String, Map<String, Object>>>();
            payload.put(ADDITIONAL_INFO_FOR_SM, additionalInfoForSM);
            additionalInfoForSM.put("hdi", hdi);
            if (hasProvisioningParameters) {
                hdi.put("create", serviceCreateOptions.getProvisioningParameters());
            }
            if (hasBindingParameters) {
                hdi.put("bind", serviceCreateOptions.getBindingParameters());
            }
        }
        return payload;
    }

    public static Object lazyJson(final Supplier<Object> callable) {
        return new Object(){

            public String toString() {
                if (callable == null) {
                    return "{\n  \"value\": \"null\"\n}\n";
                }
                try {
                    Object result = callable.get();
                    if (result == null) {
                        return "";
                    }
                    return objectMapper.writeValueAsString(result);
                }
                catch (Exception e) {
                    return "";
                }
            }
        };
    }
}

