/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.feature.mt.MtUtils;
import com.sap.cds.feature.mt.lib.subscription.HanaEncryptionTool;
import com.sap.cds.feature.mt.lib.subscription.HdiContainerManager;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManager;
import com.sap.cds.feature.mt.lib.subscription.LiquibaseParameters;
import com.sap.cds.feature.mt.lib.subscription.PollingParameters;
import com.sap.cds.feature.mt.lib.subscription.ProvisioningService;
import com.sap.cds.feature.mt.lib.subscription.SecurityChecker;
import com.sap.cds.feature.mt.lib.subscription.ServiceSpecification;
import com.sap.cds.feature.mt.lib.subscription.Subscriber;
import com.sap.cds.feature.mt.lib.subscription.SubscriberBuilder;
import com.sap.cds.feature.mt.lib.subscription.SubscriberImpl;
import com.sap.cds.feature.mt.lib.subscription.exceptions.AuthorityError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.NotFound;
import com.sap.cds.feature.mt.lib.subscription.exceptions.NotSupported;
import com.sap.cds.feature.mt.lib.subscription.exceptions.ParameterError;
import com.sap.cds.feature.mt.lib.subscription.exits.Exits;
import com.sap.cds.feature.mt.lib.subscription.exits.SubscribeExit;
import com.sap.cds.feature.mt.lib.subscription.exits.UnSubscribeExit;
import com.sap.cds.feature.mt.lib.subscription.json.DeletePayload;
import com.sap.cds.feature.mt.lib.subscription.json.SubscriptionPayload;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.SubscribeEventContext;
import com.sap.cds.services.mt.UnsubscribeEventContext;
import com.sap.cds.services.mt.UpgradeEventContext;
import com.sap.cds.services.mt.impl.AsyncSidecarUpgradeHelper;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.lib.tools.api.InstanceCreationOptions;
import com.sap.cds.services.utils.lib.tools.api.ResilienceConfig;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationLoader;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"DeploymentService$Default"})
public class MtDeploymentServiceHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(MtDeploymentServiceHandler.class);
    protected final Subscriber subscriber;
    protected final ThreadLocal<InstanceCreationOptions> options = new ThreadLocal();
    private final boolean useHanaX509;

    public MtDeploymentServiceHandler(InstanceLifecycleManager instanceLifecycleManager, CdsRuntime runtime) {
        try {
            CdsProperties.MultiTenancy config = runtime.getEnvironment().getCdsProperties().getMultiTenancy();
            this.useHanaX509 = config.getDataSource().getX509().isEnabled();
            MtUtils mtUtils = new MtUtils(runtime);
            DynamicModelUtils dynamicModelUtils = new DynamicModelUtils(runtime);
            ResilienceConfig resilienceConfig = dynamicModelUtils.getResilienceConfig();
            ArrayList<Object> destinations = new ArrayList<Object>();
            ProvisioningService provisioningService = null;
            if (!StringUtils.isEmpty((String)mtUtils.getProvisioningServiceUrl())) {
                PollingParameters pollingParameters = PollingParameters.Builder.create().interval(config.getProvisioning().getPollingInterval()).timeout(config.getProvisioning().getPollingTimeout()).build();
                provisioningService = new ProvisioningService(ServiceSpecification.Builder.create().resilienceConfig(resilienceConfig).polling(pollingParameters).build());
                destinations.add(dynamicModelUtils.createSidecarDestination("com.sap.cds.mtxSidecar", mtUtils.getProvisioningServiceUrl()));
            }
            HdiContainerManager hdiContainerManager = null;
            if (!StringUtils.isEmpty((String)config.getDeployer().getUrl())) {
                PollingParameters pollingParameters = PollingParameters.Builder.create().interval(Duration.ofSeconds(5L)).timeout(config.getDeployer().getAsyncTimeout()).build();
                hdiContainerManager = new HdiContainerManager(ServiceSpecification.Builder.create().polling(pollingParameters).resilienceConfig(resilienceConfig).build(), null);
                destinations.add(DefaultHttpDestination.builder((String)config.getDeployer().getUrl()).name("com.sap.cds.mtHdiDynamicDeployer").basicCredentials(new BasicCredentials(config.getDeployer().getUser(), config.getDeployer().getPassword())).build());
            }
            DefaultDestinationLoader destinationLoader = new DefaultDestinationLoader();
            destinations.forEach(d -> destinationLoader.registerDestination(d));
            DestinationAccessor.prependDestinationLoader((DestinationLoader)destinationLoader);
            String encryptionMode = config.getDataSource().getHanaEncryptionMode();
            this.subscriber = SubscriberBuilder.create().instanceLifecycleManager(instanceLifecycleManager).hdiContainerManager(hdiContainerManager).provisioningService(provisioningService).exits(this.getExits()).securityChecker(this.getSecurityChecker()).hanaEncryptionMode(encryptionMode != null ? HanaEncryptionTool.DbEncryptionMode.valueOf(encryptionMode) : null).liquibaseParameters(new LiquibaseParameters(config.getLiquibase().getChangeLog(), config.getLiquibase().getContexts(), null)).baseUiUrl(config.getAppUi().getUrl()).urlSeparator(config.getAppUi().getTenantSeparator()).build();
        }
        catch (InternalError | IllegalArgumentException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SUBSCRIBER_FAILED, new Object[]{e});
        }
    }

    private SecurityChecker getSecurityChecker() {
        return new SecurityChecker(){

            @Override
            public void checkSubscriptionAuthority() throws AuthorityError {
            }

            @Override
            public void checkInitDbAuthority() throws AuthorityError {
            }
        };
    }

    private Exits getExits() {
        return new Exits(new UnSubscribeExit(){

            @Override
            public Boolean onBeforeUnsubscribe(String tenantId, DeletePayload deletePayload) {
                return true;
            }

            @Override
            public Boolean onBeforeAsyncUnsubscribe(String tenantId, DeletePayload deletePayload) {
                return true;
            }
        }, new SubscribeExit(){

            @Override
            public InstanceCreationOptions onBeforeSubscribe(String tenantId, SubscriptionPayload subscriptionPayload) throws InternalError {
                return MtDeploymentServiceHandler.this.options.get();
            }

            @Override
            public InstanceCreationOptions onBeforeAsyncSubscribe(String tenantId, SubscriptionPayload subscriptionPayload) throws InternalError {
                return MtDeploymentServiceHandler.this.options.get();
            }
        }, null, null, null, false);
    }

    @On
    @HandlerOrder(value=-9900)
    protected void onSubscribe(SubscribeEventContext context) {
        try {
            this.options.set(this.buildInstanceCreationOptions(context));
            SubscriptionPayload payload = new SubscriptionPayload(context.getOptions());
            this.subscriber.subscribe(context.getTenant(), payload);
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SUBSCRIPTION_FAILED, new Object[]{context.getTenant(), e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
        finally {
            this.options.remove();
        }
    }

    @On
    protected void onUnsubscribe(UnsubscribeEventContext context) {
        try {
            logger.info("Deleting subscription of tenant '{}'", (Object)context.getTenant());
            DeletePayload payload = new DeletePayload(context.getOptions());
            this.subscriber.unsubscribe(context.getTenant(), payload);
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUBSCRIPTION_FAILED, new Object[]{context.getTenant(), e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
    }

    @On
    @HandlerOrder(value=-9900)
    protected void onUpgrade(UpgradeEventContext context) {
        try {
            if (this.subscriber instanceof SubscriberImpl) {
                this.subscriber.setupDbTables(context.getTenants());
            } else {
                new AsyncSidecarUpgradeHelper(this.subscriber).deploy(context.getTenants());
            }
        }
        catch (InternalError | NotFound e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.DEPLOYMENT_FAILED, new Object[]{String.join((CharSequence)",", context.getTenants()), e});
        }
        catch (NotSupported e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[]{e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
    }

    @Before
    protected void beforeSubscribe(SubscribeEventContext context) {
        if (this.useHanaX509) {
            logger.debug("Setting credential type to X509 for subscription of tenant '{}'", (Object)context.getTenant());
            if (context.getOptions() == null) {
                context.setOptions(new HashMap());
            }
            Map binding = (Map)context.getOptions().computeIfAbsent("bindingParameters", k -> new HashMap());
            binding.put("credential-type", "X509");
        }
    }

    protected InstanceCreationOptions buildInstanceCreationOptions(SubscribeEventContext context) {
        Object binding;
        InstanceCreationOptions ico = new InstanceCreationOptions();
        Object provisioning = context.getOptions().get("provisioningParameters");
        if (provisioning instanceof Map) {
            ico.withProvisioningParameters((Map)provisioning);
        }
        if ((binding = context.getOptions().get("bindingParameters")) instanceof Map) {
            ico.withBindingParameters((Map)binding);
        }
        return ico.getProvisioningParameters() != null || ico.getBindingParameters() != null ? ico : null;
    }
}

