/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

public final class DataSourceInfoBuilder {
  private String schema;
  private String driver;
  private String port;
  private String host;
  private String user;
  private String userName;
  private String password;
  private String hdiUser;
  private String hdiUserName;
  private String hdiPassword;
  private String credentialType;
  private String url;
  private String certificate;
  private String tenantId;
  private String id;
  private String statusAsText;
  private String dbKey;
  private String databaseId;

  public static DataSourceInfoBuilder createBuilder() {
    return new DataSourceInfoBuilder();
  }

  public DataSourceInfoBuilder schema(String schema) {
    this.schema = schema;
    return this;
  }

  public DataSourceInfoBuilder driver(String driver) {
    this.driver = driver;
    return this;
  }

  public DataSourceInfoBuilder port(String port) {
    this.port = port;
    return this;
  }

  public DataSourceInfoBuilder host(String host) {
    this.host = host;
    return this;
  }

  public DataSourceInfoBuilder user(String user) {
    this.user = user;
    return this;
  }

  public DataSourceInfoBuilder userName(String userName) {
    this.userName = userName;
    return this;
  }

  public DataSourceInfoBuilder password(String password) {
    this.password = password;
    return this;
  }

  public DataSourceInfoBuilder hdiUser(String hdiUser) {
    this.hdiUser = hdiUser;
    return this;
  }

  public DataSourceInfoBuilder hdiUserName(String hdiUserName) {
    this.hdiUserName = hdiUserName;
    return this;
  }

  public DataSourceInfoBuilder hdiPassword(String hdiPassword) {
    this.hdiPassword = hdiPassword;
    return this;
  }

  public DataSourceInfoBuilder credentialType(String credentialType) {
    this.credentialType = credentialType;
    return this;
  }

  public DataSourceInfoBuilder url(String url) {
    this.url = url;
    return this;
  }

  public DataSourceInfoBuilder certificate(String certificate) {
    this.certificate = certificate;
    return this;
  }

  public DataSourceInfoBuilder tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  public DataSourceInfoBuilder id(String id) {
    this.id = id;
    return this;
  }

  public DataSourceInfoBuilder statusAsText(String statusAsText) {
    this.statusAsText = statusAsText;
    return this;
  }

  public DataSourceInfoBuilder dbKey(String dbKey) {
    this.dbKey = dbKey;
    return this;
  }

  public DataSourceInfoBuilder databaseId(String databaseId) {
    this.databaseId = databaseId;
    return this;
  }

  public DataSourceInfo build() {
    DataSourceInfo dataSourceInfo = new DataSourceInfo();
    dataSourceInfo.setSchema(schema);
    dataSourceInfo.setDriver(driver);
    dataSourceInfo.setPort(port);
    dataSourceInfo.setHost(host);
    dataSourceInfo.setUser(user);
    dataSourceInfo.setUserName(userName);
    dataSourceInfo.setPassword(password);
    dataSourceInfo.setHdiUser(hdiUser);
    dataSourceInfo.setHdiUserName(hdiUserName);
    dataSourceInfo.setHdiPassword(hdiPassword);
    dataSourceInfo.setCredentialType(credentialType);
    dataSourceInfo.setUrl(url);
    dataSourceInfo.setCertificate(certificate);
    dataSourceInfo.setTenantId(tenantId);
    dataSourceInfo.setId(id);
    dataSourceInfo.setStatusAsText(statusAsText);
    dataSourceInfo.setDbKey(dbKey);
    dataSourceInfo.setDatabaseId(databaseId);
    return dataSourceInfo;
  }
}
