/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

import static java.util.Objects.requireNonNull;

import java.nio.file.Path;

public class DbIdentifiersSqLite implements DbIdentifiers {

  private final Path root;

  public DbIdentifiersSqLite(Path root) {
    this.root = requireNonNull(root);
  }

  @Override
  public boolean areSet() {
    return true;
  }

  @Override
  public DB getDB() {
    return DB.SQLITE;
  }

  @Override
  public DbIdentifiers createCopy() {
    return null;
  }

  public Path getRoot() {
    return root;
  }
}
