/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

public class LiquibaseParameters {
  private final String fileName;
  private final String contexts;
  private final LiquibaseResourceAccessor resourceAccessor;

  public LiquibaseParameters(
      String fileName, String contexts, LiquibaseResourceAccessor resourceAccessor) {
    this.fileName = fileName;
    this.contexts = contexts;
    this.resourceAccessor = resourceAccessor;
  }

  public String getFileName() {
    return fileName;
  }

  public String getContexts() {
    return contexts;
  }

  public LiquibaseResourceAccessor getResourceAccessor() {
    return resourceAccessor;
  }
}
