/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.exceptions.AuthorityError;

public interface SecurityChecker {
  public void checkSubscriptionAuthority() throws AuthorityError;

  public void checkInitDbAuthority() throws AuthorityError;

  public default void checkAuthority(Authority authority) throws AuthorityError {
    switch (authority) {
      case SUBSCRIBE, UNSUBSCRIBE -> checkSubscriptionAuthority();
      case INIT_DB -> checkInitDbAuthority();
    }
  }

  public enum Authority {
    SUBSCRIBE,
    UNSUBSCRIBE,
    INIT_DB;
  }
}
