/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

public class SqlOperationsHana extends SqlOperations {

  private static final String SELECT_SCHEMA = "SELECT * FROM SCHEMAS";
  private static final String DUMMY_SELECT = "select 1 as a from dummy";

  @Override
  protected String getDeleteSchemaStatement(String tenantId) {
    return "DROP SCHEMA \"%s\" CASCADE".formatted(tenantId);
  }

  @Override
  protected String getSelectSchemaStatement() {
    return SELECT_SCHEMA;
  }

  @Override
  protected String getDummySelect() {
    return DUMMY_SELECT;
  }
}
