/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

import java.util.Map;

public interface SubscriptionPayloadAccess {

  String getGlobalAccountId();

  String getSubAccountId();

  String getApplicationName();

  String getEventType();

  String getSubDomain();

  static SubscriptionPayloadAccess create(Map<String, Object> payload) {
    if (payload.containsKey("subscriber")) {
      return new SubscriptionPayloadAccessForSMS(payload);
    } else {
      return new SubscriptionPayloadAccessForSaasRegistry(payload);
    }
  }
}
