/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

import java.util.Map;

public class SubscriptionPayloadAccessForSMS implements SubscriptionPayloadAccess {
  public static final String SUBSCRIBER = "subscriber";
  public static final String GLOBAL_ACCOUNT_ID = "globalAccountId";
  public static final String SUBACCOUNT_ID = "subaccountId";
  public static final String ROOT_APPLICATION = "rootApplication";
  public static final String APP_NAME = "appName";
  public static final String EVENT_TYPE = "eventType";
  public static final String SUBACCOUNT_SUBDOMAIN = "subaccountSubdomain";
  private final Map<String, Object> payload;

  public SubscriptionPayloadAccessForSMS(Map<String, Object> payload) {
    this.payload = payload;
  }

  @Override
  @SuppressWarnings("unchecked")
  public String getGlobalAccountId() {
    Map<String, Object> subscriber;
    if (payload.containsKey(SUBSCRIBER)) {
      subscriber = (Map<String, Object>) payload.get(SUBSCRIBER);
    } else {
      return "";
    }
    return subscriber.containsKey(GLOBAL_ACCOUNT_ID)
        ? (String) subscriber.get(GLOBAL_ACCOUNT_ID)
        : "";
  }

  @Override
  @SuppressWarnings("unchecked")
  public String getSubAccountId() {
    Map<String, Object> subscriber;
    if (payload.containsKey(SUBSCRIBER)) {
      subscriber = (Map<String, Object>) payload.get(SUBSCRIBER);
    } else {
      return "";
    }
    return subscriber.containsKey(SUBACCOUNT_ID) ? (String) subscriber.get(SUBACCOUNT_ID) : "";
  }

  @Override
  @SuppressWarnings("unchecked")
  public String getApplicationName() {
    Map<String, Object> rootApplication;
    if (payload.containsKey(ROOT_APPLICATION)) {
      rootApplication = (Map<String, Object>) payload.get(ROOT_APPLICATION);
    } else {
      return "";
    }
    return rootApplication.containsKey(APP_NAME) ? (String) rootApplication.get(APP_NAME) : "";
  }

  @Override
  @SuppressWarnings("unchecked")
  public String getSubDomain() {
    Map<String, Object> subscriber;
    if (payload.containsKey(SUBSCRIBER)) {
      subscriber = (Map<String, Object>) payload.get(SUBSCRIBER);
    } else {
      return "";
    }
    return subscriber.containsKey(SUBACCOUNT_SUBDOMAIN)
        ? (String) subscriber.get(SUBACCOUNT_SUBDOMAIN)
        : "";
  }

  @Override
  public String getEventType() {
    return payload.containsKey(EVENT_TYPE) ? (String) payload.get(EVENT_TYPE) : "";
  }
}
