/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription.hana.mt.service;

import static com.sap.cds.feature.mt.lib.subscription.hana.mt.service.Tools.asListMap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Credential extends HashMap<String, Object> {

  private static final String CREATE_TIMESTAMP_NODE = "createTimestamp";
  private static final String STATE_NODE = "state";
  private static final String CREATE_SUCCEEDED_STATE = "CREATE_SUCCEEDED";
  private static final String ID_NODE = "id";
  private static final String CERTIFICATE_NODE = "certificate";
  private static final String DATABASE_ID_NODE = "serviceInstanceID";
  private static final String DRIVER_NODE = "driver";
  private static final String HDI_PASSWORD_NODE = "hdiPassword";
  private static final String HDI_USER_NODE = "hdiUser";
  private static final String HOST_NODE = "host";
  private static final String PASSWORD_NODE = "password";
  private static final String PORT_NODE = "port";
  private static final String SCHEMA_NODE = "schema";
  private static final String URL_NODE = "url";
  private static final String USER_NODE = "user";
  private static final String DATA_NODE = "data";

  public Credential(Map<String, Object> m) {
    super(m);
  }

  public boolean isValid() {
    return containsKey(STATE_NODE) && ((String) get(STATE_NODE)).equals(CREATE_SUCCEEDED_STATE);
  }

  public String getId() {
    if (!containsKey(ID_NODE)) {
      return "";
    }
    return (String) get(ID_NODE);
  }

  public String getCertificate() {
    if (containsKey(CERTIFICATE_NODE)) {
      return (String) get(CERTIFICATE_NODE);
    } else {
      return "";
    }
  }

  public String getDatabaseId() {
    if (containsKey(DATABASE_ID_NODE)) {
      return (String) get(DATABASE_ID_NODE);
    } else {
      return "";
    }
  }

  public String getDriver() {
    if (containsKey(DRIVER_NODE)) {
      return (String) get(DRIVER_NODE);
    } else {
      return "";
    }
  }

  public String getHdiPassword() {
    if (containsKey(HDI_PASSWORD_NODE)) {
      return (String) get(HDI_PASSWORD_NODE);
    } else {
      return "";
    }
  }

  public String getHdiUser() {
    if (containsKey(HDI_USER_NODE)) {
      return (String) get(HDI_USER_NODE);
    } else {
      return "";
    }
  }

  public String getHost() {
    if (containsKey(HOST_NODE)) {
      return (String) get(HOST_NODE);
    } else {
      return "";
    }
  }

  public String getPassword() {
    if (containsKey(PASSWORD_NODE)) {
      return (String) get(PASSWORD_NODE);
    } else {
      return "";
    }
  }

  public String getPort() {
    if (containsKey(PORT_NODE)) {
      return (String) get(PORT_NODE);
    } else {
      return "";
    }
  }

  public String getSchema() {
    if (containsKey(SCHEMA_NODE)) {
      return (String) get(SCHEMA_NODE);
    } else {
      return "";
    }
  }

  public String getUrl() {
    if (containsKey(URL_NODE)) {
      return (String) get(URL_NODE);
    } else {
      return "";
    }
  }

  public String getUser() {
    if (containsKey(USER_NODE)) {
      return (String) get(USER_NODE);
    } else {
      return "";
    }
  }

  public static List<Credential> getCredentialsFromPayload(Map<String, Object> payload) {
    var credentials = new ArrayList<Credential>();
    if (payload.containsKey(DATA_NODE)) {
      asListMap(payload.get(DATA_NODE))
          .forEach(credential -> credentials.add(new Credential(credential)));
    }
    return credentials;
  }

  public static Map<String, Object> createCreatePayload() {
    var payload = new HashMap<String, Object>();
    return payload;
  }
}
