/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.mt;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import java.util.Map;

/** Payload for a delete subscription request from the SMS (Subscription Manager Service). */
public interface SmsUnsubscriptionRequest extends CdsData {

  static SmsUnsubscriptionRequest create() {
    return Struct.create(SmsUnsubscriptionRequest.class);
  }

  static SmsUnsubscriptionRequest create(Map<String, Object> attributes) {
    return Struct.access(attributes).as(SmsUnsubscriptionRequest.class);
  }

  /**
   * Includes the IAS service instance ID of the application.
   *
   * @return the service instance ID
   */
  String getOwnServiceInstance();

  void setOwnServiceInstance(String instanceId);

  /**
   * The dependent service instances separated by ';'. r
   *
   * @return the dependent service instances
   */
  String getServiceInstances();

  void setServiceInstances(String instances);

  /**
   * The application's plan.
   *
   * @return the app plan
   */
  String getPlanName();

  void setPlanName(String planName);
}
