/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.mt.ExtensibilityService;
import com.sap.cds.services.mt.ModelChangedEventContext;
import com.sap.cds.services.utils.OrderConstants;

public class ExtensibilityServiceImpl extends ServiceDelegator implements ExtensibilityService {

  protected ExtensibilityServiceImpl(String name) {
    super(name);
  }

  @On
  @HandlerOrder(OrderConstants.On.AUTO_COMPLETE)
  protected void completeModelChangedEvent(ModelChangedEventContext context) {
    context.setCompleted();
  }
}
