/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.adapter.sms;

import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.feature.mt.SmsClient;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.path.UrlPathUtil;
import com.sap.cds.services.utils.path.UrlResourcePathBuilder;

/** Factory for the subscription adapter. */
public class SmsProvisioningAdapterFactory implements ServletAdapterFactory, CdsRuntimeAware {

  private CdsRuntime runtime;

  @Override
  public void setCdsRuntime(CdsRuntime runtime) {
    this.runtime = runtime;
  }

  @Override
  public Object create() {
    return new SmsProvisioningServlet(runtime);
  }

  @Override
  public boolean isEnabled() {
    if (SmsClient.findBinding(runtime).isPresent()) {
      return runtime
          .getEnvironment()
          .getCdsProperties()
          .getMultiTenancy()
          .getSubscriptionManager()
          .getEndpoint()
          .isEnabled();
    }
    return false;
  }

  @Override
  public String getBasePath() {
    return UrlPathUtil.normalizeBasePath(
        runtime
            .getEnvironment()
            .getCdsProperties()
            .getMultiTenancy()
            .getSubscriptionManager()
            .getEndpoint()
            .getPath());
  }

  @Override
  public String[] getMappings() {
    return new String[] {UrlResourcePathBuilder.path(getBasePath()).recursive().build().getPath()};
  }

  @Override
  public UrlResourcePath getServletPath() {
    // Certificate is checked by service handler (authentication + authorization)
    return UrlResourcePathBuilder.path(getBasePath()).recursive().isPublic(true).build();
  }
}
