/*
 * © 2024-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import java.sql.Connection;
import java.sql.SQLException;

/** Functional Interface for a function that returns a DB connection for a tenant */
@FunctionalInterface
public interface ConnectionProvider {
  /**
   * Request a connection for a tenant.
   *
   * @param tenantId Identifier of tenant for whom a connection is requested.
   * @param dataSourceAndInfo Connection pool instance responsible for the tenant as datasource and
   *     tenant credentials as info. In case mode combinePools is used, one connection pool per DB
   *     is created using credentials issued to a technical user. In this case the credentials used
   *     by the pool are different from the tenant-credentials provided in the info part of this
   *     parameter.
   * @param libContainerInfo Credentials of technical user used in mode combine pools.
   * @return
   * @throws SQLException
   */
  public Connection getConnection(
      String tenantId, DataSourceAndInfo dataSourceAndInfo, DataSourceInfo libContainerInfo)
      throws SQLException;
}
