/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.runtime;

public class HealthCheckResult {
  private final String dbIdentifier;
  private final boolean ok;
  private final Exception exception;

  public HealthCheckResult(String dbIdentifier, boolean ok, Exception exception) {
    this.dbIdentifier = dbIdentifier;
    this.ok = ok;
    this.exception = exception;
  }

  public String getDbIdentifier() {
    return dbIdentifier;
  }

  public boolean isOk() {
    return ok;
  }

  public Exception getException() {
    return exception;
  }
}
