/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class DbIdentifiersSql implements DbIdentifiers {
  private final List<DbCredentials> credentials;

  public DbIdentifiersSql(List<DbCredentials> credentials) {
    this.credentials = credentials;
  }

  public DbIdentifiersSql(DbIdentifiersSql dbIdentifiersSql) {
    credentials = new ArrayList<>();
    dbIdentifiersSql.credentials.stream().forEach(c -> credentials.add(c.createCopy()));
  }

  @Override
  public boolean areSet() {
    return credentials != null && !credentials.isEmpty();
  }

  @Override
  public DB getDB() {
    if (!credentials.isEmpty()) {
      return credentials.get(0).getDB();
    } else {
      return DB.NONE;
    }
  }

  public Optional<DbCredentials> getCredentials(String databaseId) {
    return credentials.stream().filter(c -> c.getDatabaseId().equals(databaseId)).findFirst();
  }

  public Optional<DbCredentials> getLast() {
    if (credentials == null || credentials.isEmpty()) {
      return Optional.empty();
    } else {
      return Optional.of(credentials.get(credentials.size() - 1));
    }
  }

  public Stream<DbCredentials> asStream() {
    return credentials.stream();
  }

  @Override
  public DbIdentifiers createCopy() {
    return new DbIdentifiersSql(this);
  }
}
