/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface HanaAccess {
  public Optional<ServiceInstance> getInstance(String tenantId, boolean forceCacheUpdate)
      throws InternalError;

  public List<TenantInfo> getAllTenants(boolean forceCacheUpdate) throws InternalError;

  public Set<String> getDatabaseIds(boolean forceCacheUpdate) throws InternalError;

  public void deleteInstance(String tenantId) throws InternalError;

  public ServiceInstance createInstance(
      String tenantId,
      ProvisioningParameters provisioningParameters,
      BindingParameters bindingParameters)
      throws InternalError;

  public void clearCache();

  public record TenantInfo(String tenantId, String databaseId, boolean isUsable) {}
}
