/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription.hana.mt.service;

import com.sap.cds.feature.mt.MtUtils;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import java.net.URI;
import java.util.Collections;

public class HanaMtPropertySupplier extends DefaultOAuth2PropertySupplier {

  public static final String API_URL = "baseurl";
  public static final String HANA_MULTITENANCY_PLAN = "hana-multitenancy";
  public static final String OAUTH_PATH = "uaa";
  public static final String HANA_CLOUD = "hana-cloud";
  private static volatile boolean initialized = false;

  public HanaMtPropertySupplier(ServiceBindingDestinationOptions options) {
    super(options, Collections.singletonList(OAUTH_PATH));
  }

  public static synchronized void initialize() {
    if (!initialized) {
      OAuth2ServiceBindingDestinationLoader.registerPropertySupplier(
          HanaMtPropertySupplier::matches, HanaMtPropertySupplier::new);
      initialized = true;
    }
  }

  private static boolean matches(ServiceBindingDestinationOptions options) {
    var binding = options.getServiceBinding();
    return MtUtils.isHanaMtServiceBinding(binding);
  }

  @Override
  public URI getServiceUri() {
    var baseUrl = getCredentialOrThrow(String.class, API_URL);
    if (!baseUrl.startsWith("http://") && !baseUrl.startsWith("https://")) {
      baseUrl = "https://" + baseUrl;
    }
    URI uri;
    try {
      uri = URI.create(baseUrl);
    } catch (IllegalArgumentException e) {
      throw new DestinationAccessException(e);
    }
    return uri;
  }
}
