/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription.hana.mt.service;

import java.util.Map;

public class Status {
  public static final String READY_STATE_NODE = "ready";
  public static final String STATE_NODE = "state";
  public static final String CREATE_IN_PROGRESS_STATE = "CREATE_IN_PROGRESS";
  private final Map<String, Object> statusMap;

  public Status(Map<String, Object> statusMap) {
    this.statusMap = statusMap;
  }

  public boolean isInProgress() {
    if (statusMap == null || statusMap.isEmpty()) {
      return false;
    }
    var ready = (Boolean) statusMap.get(READY_STATE_NODE);
    var state = (String) statusMap.get(STATE_NODE);
    if (ready == null || state == null) {
      return false;
    }
    return !ready && state.equals(CREATE_IN_PROGRESS_STATE);
  }

  public boolean isReady() {
    if (statusMap == null) {
      return false;
    }
    var ready = (Boolean) statusMap.get(READY_STATE_NODE);
    return ready != null && ready;
  }
}
