/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.mt.lib.subscription.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTenantLcmPayload {
  public String subscriptionGUID; // NOSONAR
  public String subscriptionAppId; // NOSONAR
  public String subscriptionAppName; // NOSONAR
  public String subscribedTenantId; // NOSONAR
  public String subscribedZoneId; // NOSONAR
  public String subscribedSubdomain; // NOSONAR
  public String subscribedCrmId; // NOSONAR
  public String subscribedSubaccountId; // NOSONAR
  public String subscriptionAppPlan; // NOSONAR
  public String subscriptionAppAmount; // NOSONAR
  public String[] dependentServiceInstanceAppIds; // NOSONAR
  public String[] dependantServiceInstanceAppIds; // NOSONAR
  public String globalAccountGUID; // NOSONAR
  public String userId; // NOSONAR
  public UserInfo userInfo; // NOSONAR

  @JsonIgnore
  private static final Logger logger = LoggerFactory.getLogger(AbstractTenantLcmPayload.class);

  @JsonIgnore protected final Map<String, Object> map = new HashMap<>();
  @JsonIgnore protected static final ObjectMapper mapper = new ObjectMapper();

  protected AbstractTenantLcmPayload(Map<String, Object> map) {
    this.map.putAll(map);
    fillAttributesFromMap();
  }

  protected AbstractTenantLcmPayload() {}

  @SuppressWarnings("unchecked")
  public Map<String, Object> getMap() {
    if (map.isEmpty() && attributesSet()) {
      // for compatibility if parameters are set in attributes //
      map.putAll(mapper.convertValue(this, Map.class));
    }
    return map;
  }

  @Override
  public String toString() {
    try {
      return this.getClass().getName() + mapper.writeValueAsString(getMap());
    } catch (JsonProcessingException e) {
      logger.error("Could not convert map into Json", e);
      return this.getClass().getName();
    }
  }

  @SuppressWarnings("unchecked")
  protected void fillAttributesFromMap() {
    subscriptionGUID = (String) map.get("subscriptionGUID");
    subscriptionAppId = (String) map.get("subscriptionAppId");
    subscriptionAppName = (String) map.get("subscriptionAppName");
    subscribedTenantId = (String) map.get("subscribedTenantId");
    subscribedZoneId = (String) map.get("subscribedZoneId");
    subscribedSubdomain = (String) map.get("subscribedSubdomain");
    subscribedCrmId = (String) map.get("subscribedCrmId");
    subscribedSubaccountId = (String) map.get("subscribedSubaccountId");
    subscriptionAppPlan = (String) map.get("subscriptionAppPlan");
    if (map.get("subscriptionAppAmount") != null) {
      subscriptionAppAmount = map.get("subscriptionAppAmount").toString();
    }
    if (map.get("dependentServiceInstanceAppIds") != null) {
      dependentServiceInstanceAppIds =
          ((List<Object>) map.get("dependentServiceInstanceAppIds")).toArray(new String[] {""});
    }
    if (map.get("dependantServiceInstanceAppIds") != null) {
      dependantServiceInstanceAppIds =
          ((List<Object>) map.get("dependantServiceInstanceAppIds")).toArray(new String[] {""});
    }
    globalAccountGUID = (String) map.get("globalAccountGUID");
    userId = (String) map.get("userId");
    if (map.get("userInfo") != null) {
      var userInfoMap = (Map<String, Object>) map.get("userInfo");
      userInfo = new UserInfo();
      userInfo.sub = (String) userInfoMap.get("sub");
      userInfo.email = (String) userInfoMap.get("email");
      userInfo.userName = (String) userInfoMap.get("userName");
      userInfo.subIdp = (String) userInfoMap.get("subIdp");
      userInfo.userId = (String) userInfoMap.get("userId");
    }
  }

  private boolean attributesSet() {
    return (StringUtils.isNotBlank(subscribedSubdomain)
        || StringUtils.isNotBlank(globalAccountGUID)
        || StringUtils.isNotBlank(subscribedSubaccountId)
        || StringUtils.isNotBlank(subscriptionAppName)
        || StringUtils.isNotBlank(subscribedTenantId));
  }
}
