/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.feature.mt.lib.subscription.UiUrlCreator;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.services.environment.CdsProperties.MultiTenancy;
import com.sap.cds.services.environment.CdsProperties.MultiTenancy.AppUi;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.AppUiUrlEventContext;
import com.sap.cds.services.mt.DeploymentService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.OrderConstants;
import com.sap.cds.services.utils.StringUtils;

@ServiceName(DeploymentService.DEFAULT_NAME)
public class AppUiUrlEventHandler implements EventHandler {

  private static final String FALLBACK_APP_URL =
      "tenant successfully subscribed - no application URL provided";

  private final AppUi appUi;

  public AppUiUrlEventHandler(CdsRuntime runtime) {
    MultiTenancy config = runtime.getEnvironment().getCdsProperties().getMultiTenancy();
    appUi = config.getAppUi();
  }

  @On
  @HandlerOrder(OrderConstants.On.DEFAULT_ON)
  protected String onAppUiUrl(AppUiUrlEventContext context) {
    try {
      String configuredUrl =
          UiUrlCreator.createUrl(
              context.getSubdomain(), appUi.getUrl(), appUi.getTenantSeparator());
      return StringUtils.isEmpty(configuredUrl) ? FALLBACK_APP_URL : configuredUrl;
    } catch (InternalError e) {
      throw new ErrorStatusException(CdsErrorStatuses.CREATE_APP_UI_URL_FAILED, e);
    }
  }
}
