/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.subscription;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.mt.SaasClient;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.mt.DeploymentService;
import com.sap.cds.services.mt.SaasRegistryCallback;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.ExecutorUtils;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasProvisioningServlet
extends HttpServlet {
    public static final String HEADER_STATUS_CALLBACK = "STATUS_CALLBACK";
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(SaasProvisioningServlet.class);
    private static final String DEPENDENCIES = "/dependencies";
    private static final String TENANTS = "/tenants/";
    private static final String SUCCEEDED = "SUCCEEDED";
    private static final String FAILED = "FAILED";
    private final CdsRuntime runtime;
    private final DeploymentService deploymentService;
    private final SaasClient saas;
    private final boolean isInternalUserAccessEnabled;

    public SaasProvisioningServlet(CdsRuntime runtime) {
        this.runtime = runtime;
        this.isInternalUserAccessEnabled = runtime.getEnvironment().getCdsProperties().getSecurity().getAuthentication().getInternalUserAccess().isEnabled();
        this.deploymentService = (DeploymentService)runtime.getServiceCatalog().getService(DeploymentService.class, "DeploymentService$Default");
        ServiceBinding saasBinding = SaasClient.findBinding(runtime).orElse(null);
        this.saas = saasBinding != null ? new SaasClient(saasBinding) : null;
    }

    private static String getTenantId(HttpServletRequest req) {
        String tenantId = req.getPathInfo().split("/")[2];
        if (StringUtils.isEmpty((String)tenantId)) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_FOUND, new Object[0]);
        }
        return tenantId;
    }

    private static void setContentType(HttpServletResponse resp, ContentType contType) {
        resp.setContentType(contType.getMimeType());
        resp.setCharacterEncoding(contType.getCharset().toString());
    }

    private static Map<String, Object> toMap(InputStream stream) throws IOException {
        try {
            TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
            return (Map)mapper.readValue(stream, (TypeReference)typeRef);
        }
        catch (DatabindException e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
    }

    private static void handleSaasRegistryRaceCondition(long startTime) {
        long raceConditionWaitTime = 10000L;
        long elapsed = System.currentTimeMillis() - startTime;
        if (elapsed < raceConditionWaitTime) {
            try {
                Thread.sleep(Math.max(raceConditionWaitTime - elapsed, 0L));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void handleException(HttpServletResponse res, Locale locale, ServiceException e) {
        block10: {
            if (e.getErrorStatus().getHttpStatus() >= 500 && e.getErrorStatus().getHttpStatus() < 600) {
                logger.error("Unexpected error", (Throwable)e);
            } else {
                logger.debug("Service exception thrown", (Throwable)e);
            }
            res.setStatus(e.getErrorStatus().getHttpStatus());
            try {
                String message = e.getLocalizedMessage(locale);
                if (message == null) break block10;
                try (PrintWriter writer = res.getWriter();){
                    writer.write(message);
                }
            }
            catch (IOException e1) {
                logger.error("Failed to write error message to response", (Throwable)e1);
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.processRequest(req, res, p -> DEPENDENCIES.equals(p), () -> {
            List dependencies = this.deploymentService.dependencies();
            SaasProvisioningServlet.setContentType(res, ContentType.APPLICATION_JSON);
            res.setStatus(200);
            res.getWriter().write(mapper.writeValueAsString((Object)dependencies));
        });
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) {
        this.processRequest(req, res, p -> p.startsWith(TENANTS), () -> {
            String tenantId = SaasProvisioningServlet.getTenantId(req);
            logger.info("Creating subscription for tenant '{}'", (Object)tenantId);
            Map<String, Object> payload = SaasProvisioningServlet.toMap((InputStream)req.getInputStream());
            String callbackUrl = req.getHeader(HEADER_STATUS_CALLBACK);
            if (callbackUrl != null) {
                this.assertSaasClient();
                logger.debug("Processing subscription for tenant '{}' asynchronously", (Object)tenantId);
                long startTime = System.currentTimeMillis();
                ExecutorUtils.runAsynchronously((CdsRuntime)this.runtime, () -> {
                    boolean success = false;
                    try {
                        this.deploymentService.subscribe(tenantId, payload);
                        success = true;
                        logger.info("Subscription for tenant '{}' finished successfully", (Object)tenantId);
                    }
                    catch (Throwable e) {
                        logger.error("Subscription for tenant '{}' failed", (Object)tenantId, (Object)e);
                    }
                    try {
                        SaasProvisioningServlet.handleSaasRegistryRaceCondition(startTime);
                        this.saas.callBackSaasRegistry(this.createPayload(success, "Subscription", this.deploymentService.appUiUrl(tenantId, (String)payload.get("subscribedSubdomain"), payload)), callbackUrl);
                    }
                    catch (Throwable e) {
                        logger.error("Failed to report status for tenant '{}' to SaaS Registry", (Object)tenantId, (Object)e);
                    }
                });
                res.setStatus(202);
            } else {
                logger.debug("Processing subscription for tenant '{}' synchronously", (Object)tenantId);
                this.deploymentService.subscribe(tenantId, payload);
                res.setStatus(201);
                SaasProvisioningServlet.setContentType(res, ContentType.TEXT_PLAIN);
                res.getWriter().write(this.deploymentService.appUiUrl(tenantId, (String)payload.get("subscribedSubdomain"), payload));
            }
        });
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) {
        this.processRequest(req, res, p -> p.startsWith(TENANTS), () -> {
            String tenantId = SaasProvisioningServlet.getTenantId(req);
            logger.info("Deleting subscription for tenant '{}'", (Object)tenantId);
            Map<String, Object> payload = SaasProvisioningServlet.toMap((InputStream)req.getInputStream());
            String callbackUrl = req.getHeader(HEADER_STATUS_CALLBACK);
            if (callbackUrl != null) {
                this.assertSaasClient();
                logger.debug("Processing unsubscription for tenant '{}' asynchronously", (Object)tenantId);
                long startTime = System.currentTimeMillis();
                ExecutorUtils.runAsynchronously((CdsRuntime)this.runtime, () -> {
                    boolean success = false;
                    try {
                        this.deploymentService.unsubscribe(tenantId, payload);
                        success = true;
                        logger.info("Unsubscription for tenant '{}' finished successfully", (Object)tenantId);
                    }
                    catch (Throwable e) {
                        logger.error("Unsubscription for tenant '{}' failed", (Object)tenantId, (Object)e);
                    }
                    try {
                        SaasProvisioningServlet.handleSaasRegistryRaceCondition(startTime);
                        this.saas.callBackSaasRegistry(this.createPayload(success, "Unsubscription ", null), callbackUrl);
                    }
                    catch (Throwable e) {
                        logger.error("Failed to report status for tenant '{}' to SaaS Registry", (Object)tenantId, (Object)e);
                    }
                });
                res.setStatus(202);
            } else {
                logger.debug("Processing unsubscription for tenant '{}' synchronously", (Object)tenantId);
                this.deploymentService.unsubscribe(tenantId, payload);
                res.setStatus(204);
            }
        });
    }

    private void assertSaasClient() {
        if (this.saas == null) {
            logger.error("Asynchronous callbacks to SaaS Registry require a saas-registry binding.");
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]);
        }
    }

    private void checkAuthorization() {
        UserInfo userInfo = this.runtime.getProvidedUserInfo();
        if (userInfo.isPrivileged() || this.isInternalUserAccessEnabled && userInfo.isInternalUser()) {
            return;
        }
        String callbackScope = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy().getSecurity().getSubscriptionScope();
        if (!userInfo.hasRole(callbackScope)) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[0]);
        }
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse res, Predicate<String> pathMatcher, Processor processor) {
        if (pathMatcher.test(req.getPathInfo())) {
            try {
                this.checkAuthorization();
            }
            catch (ServiceException e) {
                SaasProvisioningServlet.handleException(res, null, e);
                return;
            }
            catch (Throwable t) {
                logger.error("Unexpected error", t);
                res.setStatus(500);
                return;
            }
            this.runtime.requestContext().systemUserProvider().featureToggles(FeatureTogglesInfo.all()).run(requestContext -> {
                try {
                    processor.process();
                }
                catch (ServiceException e) {
                    SaasProvisioningServlet.handleException(res, requestContext.getParameterInfo().getLocale(), e);
                }
                catch (Throwable t) {
                    logger.error("Unexpected error", t);
                    res.setStatus(500);
                }
            });
        } else {
            res.setStatus(404);
        }
    }

    private SaasRegistryCallback createPayload(boolean success, String msgPrefix, String subscriptionUrl) {
        SaasRegistryCallback callback = SaasRegistryCallback.create();
        if (success) {
            callback.setStatus(SUCCEEDED);
            callback.setMessage(msgPrefix + " succeeded");
        } else {
            callback.setStatus(FAILED);
            callback.setMessage(msgPrefix + " failed");
        }
        callback.setSubscriptionUrl(subscriptionUrl);
        return callback;
    }

    @FunctionalInterface
    private static interface Processor {
        public void process() throws IOException;
    }
}

