/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Objects;
import com.sap.cds.Struct;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClient;
import com.sap.cds.services.mt.SaasRegistryCallback;
import com.sap.cds.services.mt.TenantInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasClient
extends JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(SaasClient.class);
    private static final int PAGE_SIZE = 500;
    private static final String TENANT_STATE = "state";
    private static final String SAAS_REGISTRY = "saas-registry";
    private static final String SAAS_MANAGER_BASE = "/saas-manager/v1/";
    private static final String APPLICATION_TENANTS_PATH = "/saas-manager/v1/application/subscriptions";
    private static final String SERVICE_TENANTS_PATH = "/saas-manager/v1/service/subscriptions?includeIndirectSubscriptions=true";
    private static final String KEY_TENANT_ID = "consumerTenantId";
    private static final String KEY_SUBDOMAIN = "subdomain";
    private final String urlPath;

    public static Optional<ServiceBinding> findBinding(CdsRuntime runtime) {
        return runtime.getEnvironment().getServiceBindings().filter(b -> ServiceBindingUtils.matches((ServiceBinding)b, null, (String)SAAS_REGISTRY)).findFirst();
    }

    public static TenantInfo toTenantInfo(Map<String, Object> tenant) {
        TenantInfo info = (TenantInfo)Struct.access(tenant).as(TenantInfo.class);
        info.setTenant((String)info.get((Object)KEY_TENANT_ID));
        info.setSubdomain((String)info.get((Object)KEY_SUBDOMAIN));
        return info;
    }

    public SaasClient(ServiceBinding binding) {
        super(ServiceBindingDestinationOptions.forService((ServiceBinding)binding).onBehalfOf(OnBehalfOf.TECHNICAL_USER_PROVIDER).build());
        this.urlPath = "service".equals(binding.getServicePlan().orElse(null)) ? SERVICE_TENANTS_PATH : APPLICATION_TENANTS_PATH;
    }

    public void callBackSaasRegistry(SaasRegistryCallback payload, String callbackUrl) throws IOException {
        ObjectNode body = (ObjectNode)this.mapper.convertValue((Object)payload, ObjectNode.class);
        logger.debug("Calling saas registry");
        this.putRequestWithOnlyResponseCode(callbackUrl, (JsonNode)body);
    }

    public List<TenantInfo> getSubscribedTenants(UnaryOperator<TenantInfo> filter) throws IOException {
        logger.debug("Retrieving all tenants metadata from the SaaS registry");
        ArrayList<TenantInfo> result = new ArrayList<TenantInfo>();
        boolean morePages = true;
        int page = 1;
        while (morePages) {
            logger.debug("Retrieving page {} of all tenants metadata from the SaaS registry", (Object)page);
            String paginatedUrlPath = this.paginatedUrl(this.urlPath, page);
            JsonNode jsonResponse = this.getRequest(paginatedUrlPath);
            ArrayNode resp = (ArrayNode)this.getNode(jsonResponse, "subscriptions");
            BooleanNode morePagesResp = (BooleanNode)this.getNode(jsonResponse, "morePages");
            resp.forEach(tenant -> {
                String state;
                String string = state = tenant.get(TENANT_STATE) != null ? tenant.get(TENANT_STATE).asText() : null;
                if (Objects.equal((Object)state, (Object)"SUBSCRIBED") || Objects.equal((Object)state, (Object)"UPDATE_FAILED")) {
                    TenantInfo tenantInfo = SaasClient.toTenantInfo((Map)this.mapper.convertValue(tenant, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                    if (filter != null) {
                        tenantInfo = (TenantInfo)filter.apply(tenantInfo);
                    }
                    result.add(tenantInfo);
                }
            });
            morePages = morePagesResp != null && morePagesResp.booleanValue();
            ++page;
            logger.debug("More tenants metadata from the SaaS registry available: {}", (Object)(morePages ? "yes" : "no"));
        }
        return result;
    }

    public List<TenantInfo> getSubscribedTenants() throws IOException {
        return this.getSubscribedTenants(null);
    }

    private String paginatedUrl(String urlPath, int page) {
        String url = urlPath + (urlPath.contains("?") ? "&" : "?");
        url = url + "page=" + page + "&size=500";
        return url;
    }

    private <N> N getNode(JsonNode jsonResponse, String keyName) {
        return (N)jsonResponse.get(keyName);
    }

    static {
        OAuth2ServiceBindingDestinationLoader.registerPropertySupplier((ServiceIdentifier)ServiceIdentifier.of((String)SAAS_REGISTRY), OAuth2Supplier::new);
    }

    private static class OAuth2Supplier
    extends DefaultOAuth2PropertySupplier {
        public OAuth2Supplier(ServiceBindingDestinationOptions options) {
            super(options, Collections.emptyList());
        }

        public URI getServiceUri() {
            return (URI)this.getCredentialOrThrow(URI.class, new String[]{"saas_registry_url"});
        }
    }
}

