/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.lib.runtime.DataPoolSettings;
import com.sap.cds.feature.mt.lib.runtime.DataSourceLookup;
import com.sap.cds.feature.mt.lib.runtime.EnvironmentAccess;
import com.sap.cds.feature.mt.lib.runtime.HikariDataSourceLookup;
import com.sap.cds.feature.mt.lib.runtime.TomcatDataSourceLookup;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DataSourceLookupBuilder {
    private static final String TOMCAT = "tomcat";
    private static final String HIKARI = "hikari";
    private InstanceLifecycleManager instanceLifecycleManager;
    private EnvironmentAccess environmentAccess;
    private String poolProvider;
    private boolean combinePools;
    private boolean registerJmx;
    private Map<String, DataPoolSettings.ConnectionPoolType> prefixToPoolType;

    private DataSourceLookupBuilder() {
    }

    public static DataSourceLookupBuilder create() {
        return new DataSourceLookupBuilder();
    }

    public DataSourceLookup build() {
        DataPoolSettings dataPoolSettings;
        if (this.prefixToPoolType != null && !this.prefixToPoolType.isEmpty()) {
            dataPoolSettings = new DataPoolSettings(this.prefixToPoolType);
        } else {
            HashMap<String, DataPoolSettings.ConnectionPoolType> config = new HashMap<String, DataPoolSettings.ConnectionPoolType>();
            config.put("spring.datasource.hikari", DataPoolSettings.ConnectionPoolType.HIKARI);
            config.put("spring.datasource.tomcat", DataPoolSettings.ConnectionPoolType.TOMCAT);
            dataPoolSettings = new DataPoolSettings(config);
        }
        if (this.poolProvider == null || this.poolProvider.isEmpty()) {
            this.poolProvider = HIKARI;
        }
        switch (this.poolProvider.toLowerCase(Locale.ENGLISH)) {
            case "tomcat": {
                return new TomcatDataSourceLookup(this.instanceLifecycleManager, this.environmentAccess, dataPoolSettings, this.combinePools, this.registerJmx);
            }
            case "hikari": {
                return new HikariDataSourceLookup(this.instanceLifecycleManager, this.environmentAccess, dataPoolSettings, this.combinePools);
            }
        }
        throw new IllegalArgumentException("Pool provider " + this.poolProvider + " is not supported");
    }

    public DataSourceLookupBuilder instanceLifecycleManager(InstanceLifecycleManager instanceLifecycleManager) {
        this.instanceLifecycleManager = instanceLifecycleManager;
        return this;
    }

    public DataSourceLookupBuilder environmentAccess(EnvironmentAccess environmentAccess) {
        this.environmentAccess = environmentAccess;
        return this;
    }

    public DataSourceLookupBuilder poolProvider(String poolProvider) {
        this.poolProvider = poolProvider;
        return this;
    }

    public DataSourceLookupBuilder combinePools(boolean combinePools) {
        this.combinePools = combinePools;
        return this;
    }

    public DataSourceLookupBuilder registerJmx(boolean registerJmx) {
        this.registerJmx = registerJmx;
        return this;
    }

    public DataSourceLookupBuilder prefixToPoolType(Map<String, DataPoolSettings.ConnectionPoolType> prefixToPoolType) {
        this.prefixToPoolType = prefixToPoolType;
        return this;
    }
}

