/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.runtime;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantOverwrite
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TenantOverwrite.class);
    private static final ThreadLocal<TenantAndCount> overwritePerThread = new ThreadLocal();

    public TenantOverwrite(String tenantId) {
        TenantAndCount tenantAndCount;
        if (logger.isDebugEnabled()) {
            logger.debug("Tenant overwrite called with tenant id {}", (Object)tenantId);
            StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
            StackWalker.StackFrame frame = walker.walk(stream -> stream.skip(1L).findFirst().orElse(null));
            if (frame != null) {
                logger.debug("class={} method={}", (Object)frame.getClassName(), (Object)frame.getMethodName());
            }
        }
        if ((tenantAndCount = overwritePerThread.get()) != null) {
            logger.debug("There is already a tenant overwrite with count {}", (Object)tenantAndCount.callDepth);
            if (!tenantAndCount.getTenantId().equals(tenantId)) {
                throw new UnsupportedOperationException("It is not supported to stack overwrites with different tenants");
            }
        } else {
            tenantAndCount = new TenantAndCount(tenantId);
            overwritePerThread.set(tenantAndCount);
        }
        tenantAndCount.inc();
    }

    public static boolean isOverwritten() {
        return overwritePerThread.get() != null;
    }

    public static String getTenantId() {
        return overwritePerThread.get() != null ? overwritePerThread.get().getTenantId() : null;
    }

    @Override
    public void close() {
        logger.debug("Tenant overwrite close called");
        if (overwritePerThread.get() != null) {
            overwritePerThread.get().dec();
            if (overwritePerThread.get().counterIsZero()) {
                logger.debug("Tenant overwrite is deleted");
                overwritePerThread.remove();
            }
        }
    }

    private static class TenantAndCount {
        private String tenantId;
        private int callDepth = 0;

        public TenantAndCount(String tenantId) {
            this.tenantId = tenantId;
        }

        public void inc() {
            ++this.callDepth;
        }

        public void dec() {
            --this.callDepth;
        }

        public boolean counterIsZero() {
            return this.callDepth == 0;
        }

        public String getTenantId() {
            return this.tenantId;
        }
    }
}

