/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.BindingParameters;
import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import com.sap.cds.feature.mt.lib.subscription.DbIdentifiers;
import com.sap.cds.feature.mt.lib.subscription.ProvisioningParameters;
import com.sap.cds.feature.mt.lib.subscription.TenantMetadata;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.UnknownTenant;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface InstanceLifecycleManager {
    public static final String DATABASE_ID = "database_id";

    public void createNewInstance(String var1, ProvisioningParameters var2, BindingParameters var3) throws InternalError;

    public void deleteInstance(String var1) throws InternalError;

    public DataSourceInfo getDataSourceInfo(String var1, boolean var2) throws InternalError, UnknownTenant;

    public ContainerStatus getContainerStatus(String var1) throws InternalError;

    public boolean hasCredentials(String var1, boolean var2) throws InternalError;

    public Map<String, TenantMetadata> getAllTenantInfos(boolean var1) throws InternalError;

    default public Set<String> getAllTenants(boolean forceCacheUpdate) throws InternalError {
        return this.getAllTenantInfos(forceCacheUpdate).keySet();
    }

    public void checkThatTenantExists(String var1) throws UnknownTenant, InternalError;

    public List<DataSourceInfo> createAndGetLibContainers(DataSourceInfo var1) throws InternalError;

    public List<DataSourceInfo> getLibContainers() throws InternalError;

    default public String getMtLibContainerName(String databaseId) {
        return "MT_LIB_TENANT-" + databaseId;
    }

    default public ProvisioningParameters createProvisioningParameters(String databaseId) {
        ProvisioningParameters provisioningParameters = new ProvisioningParameters();
        provisioningParameters.put(DATABASE_ID, databaseId);
        return provisioningParameters;
    }

    public void insertDbIdentifiers(DbIdentifiers var1);

    default public DbIdentifiers.DB getDbType() {
        return DbIdentifiers.DB.HANA;
    }

    public static enum ContainerStatus {
        OK("ok"),
        CREATION_IN_PROGRESS("creation in progress"),
        DOES_NOT_EXIST("doesn't exist"),
        CREATION_ERROR("creation error");

        private String status;

        private ContainerStatus(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }
    }
}

