/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.BindingParameters;
import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import com.sap.cds.feature.mt.lib.subscription.DataSourceInfoBuilder;
import com.sap.cds.feature.mt.lib.subscription.DbIdentifiers;
import com.sap.cds.feature.mt.lib.subscription.DbIdentifiersHana;
import com.sap.cds.feature.mt.lib.subscription.FilterTenants;
import com.sap.cds.feature.mt.lib.subscription.HanaAccess;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManager;
import com.sap.cds.feature.mt.lib.subscription.ProvisioningParameters;
import com.sap.cds.feature.mt.lib.subscription.ServiceBinding;
import com.sap.cds.feature.mt.lib.subscription.ServiceInstance;
import com.sap.cds.feature.mt.lib.subscription.ServiceOperation;
import com.sap.cds.feature.mt.lib.subscription.TenantMetadata;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.UnknownTenant;
import com.sap.cds.services.utils.lib.tools.api.UuidChecker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceLifecycleManagerImpl
implements InstanceLifecycleManager {
    private static final Logger logger = LoggerFactory.getLogger(InstanceLifecycleManagerImpl.class);
    private static final String HOST = "host";
    public static final String CREATION_SUCCEEDED = "CREATION_SUCCEEDED";
    private final HanaAccess hanaAccess;
    private Set<String> dbIds = new HashSet<String>();

    InstanceLifecycleManagerImpl(HanaAccess hanaAccess, DbIdentifiersHana dbIdentifiers) {
        if (dbIdentifiers != null) {
            this.dbIds.addAll(dbIdentifiers.getDbIds());
        }
        this.hanaAccess = hanaAccess;
    }

    @Override
    public void createNewInstance(String tenantId, ProvisioningParameters instanceParameters, BindingParameters bindingParameters) throws InternalError {
        String databaseId;
        if (instanceParameters != null && !instanceParameters.isEmpty() && (databaseId = (String)instanceParameters.get("database_id")) != null) {
            logger.debug("Using database id {}", (Object)databaseId);
        }
        this.hanaAccess.createInstance(tenantId, instanceParameters, bindingParameters);
    }

    @Override
    public void deleteInstance(String tenantId) throws InternalError {
        try {
            this.checkThatTenantExists(tenantId);
        }
        catch (UnknownTenant unknownTenant) {
            logger.warn("No HDI container for tenant {} found", (Object)tenantId);
            return;
        }
        this.hanaAccess.deleteInstance(tenantId);
    }

    @Override
    public DataSourceInfo getDataSourceInfo(String tenantId, boolean forceCacheUpdate) throws InternalError, UnknownTenant {
        return this.getDataSourceInfoInternal(tenantId, forceCacheUpdate);
    }

    protected DataSourceInfo getDataSourceInfoInternal(String tenantId, boolean forceCacheUpdate) throws InternalError, UnknownTenant {
        ServiceInstance instance = null;
        try {
            instance = this.hanaAccess.getInstance(tenantId, forceCacheUpdate).orElseThrow(() -> new UnknownTenant("Tenant [" + tenantId + "] is not known"));
        }
        catch (InternalError e) {
            throw new UnknownTenant(e, "Tenant [" + tenantId + "] is not known");
        }
        ServiceBinding binding = instance.getBinding().orElseThrow(() -> new InternalError("Database container service instance for tenant %s doesn't have a ready binding".formatted(tenantId)));
        Map<String, Object> credentials = binding.getCredentials();
        return DataSourceInfoBuilder.createBuilder().host((String)credentials.get(HOST)).port((String)credentials.get("port")).driver((String)credentials.get("driver")).url((String)credentials.get("url")).schema((String)credentials.get("schema")).hdiUser((String)credentials.get("hdi_user")).hdiUserName((String)credentials.get("hdi_user_name")).hdiPassword((String)credentials.get("hdi_password")).user((String)credentials.get("user")).userName((String)credentials.get("user_name")).password((String)credentials.get("password")).credentialType((String)credentials.get("credential-type")).certificate((String)credentials.get("certificate")).tenantId(tenantId).id(instance.getId()).statusAsText(CREATION_SUCCEEDED).dbKey(this.createDbKey((String)credentials.get(HOST), (String)credentials.get("port"))).databaseId(this.getDatabaseId(credentials)).build();
    }

    @Override
    public InstanceLifecycleManager.ContainerStatus getContainerStatus(String tenantId) throws InternalError {
        return this.hanaAccess.getInstance(tenantId, true).stream().map(instance -> {
            ServiceOperation.Status status = instance.getLastOperation().getStatus();
            ServiceOperation.Type type = instance.getLastOperation().getType();
            if (type == ServiceOperation.Type.CREATE && !instance.isReady() && status == ServiceOperation.Status.FAILED) {
                return InstanceLifecycleManager.ContainerStatus.CREATION_ERROR;
            }
            if (type == ServiceOperation.Type.CREATE && status == ServiceOperation.Status.IN_PROGRESS) {
                return InstanceLifecycleManager.ContainerStatus.CREATION_IN_PROGRESS;
            }
            return InstanceLifecycleManager.ContainerStatus.OK;
        }).findFirst().orElse(InstanceLifecycleManager.ContainerStatus.DOES_NOT_EXIST);
    }

    @Override
    public boolean hasCredentials(String tenantId, boolean forceCacheUpdate) throws InternalError {
        return this.hanaAccess.getInstance(tenantId, forceCacheUpdate).stream().map(i -> i.getBinding().isPresent()).findFirst().orElse(false);
    }

    @Override
    public Map<String, TenantMetadata> getAllTenantInfos(boolean forceCacheUpdate) throws InternalError {
        return this.hanaAccess.getAllTenants(forceCacheUpdate).stream().filter(t -> t.isUsable() && FilterTenants.realTenants().test(t.tenantId())).map(t -> new TenantMetadata(t.tenantId(), t.databaseId())).collect(Collectors.toMap(TenantMetadata::getTenantId, Function.identity()));
    }

    @Override
    public void checkThatTenantExists(String tenantId) throws UnknownTenant, InternalError {
        if (this.hanaAccess.getInstance(tenantId, false).isEmpty()) {
            throw new UnknownTenant("Tenant " + tenantId + " is not known");
        }
    }

    @Override
    public List<DataSourceInfo> createAndGetLibContainers(DataSourceInfo dataSourceInfo) throws InternalError {
        if (dataSourceInfo == null) {
            throw new InternalError("Parameter dataSourceInfo is null");
        }
        String databaseId = dataSourceInfo.getDatabaseId();
        if (this.isLibContainerMissing(databaseId)) {
            try {
                logger.debug("Create new mt-lib container for database {}", (Object)databaseId);
                this.createNewInstance(this.getMtLibContainerName(databaseId), this.createProvisioningParameters(databaseId), new BindingParameters());
            }
            catch (InternalError internalError) {
                logger.error("Could not create new mt-lib container for database {} because of {} ", (Object)databaseId, (Object)internalError.getMessage());
            }
        }
        return this.getLibContainers();
    }

    @Override
    public List<DataSourceInfo> getLibContainers() {
        ArrayList<DataSourceInfo> dsInfo = new ArrayList<DataSourceInfo>();
        this.insertDbIdsFromHana();
        logger.debug("Determine mt-lib containers");
        this.dbIds.stream().forEach(id -> {
            try {
                String mtLibContainerName = this.getMtLibContainerName((String)id);
                DataSourceInfo dsInfoEntry = this.getDataSourceInfo(mtLibContainerName, false);
                logger.debug("Credentials for mt-lib container {} read. User = {}, hdi user = {}", new Object[]{mtLibContainerName, dsInfoEntry.getUser(), dsInfoEntry.getHdiUser()});
                dsInfo.add(dsInfoEntry);
            }
            catch (InternalError | UnknownTenant object) {
                // empty catch block
            }
        });
        return dsInfo;
    }

    public void clearCache() {
        this.hanaAccess.clearCache();
    }

    private void insertDbIdsFromHana() {
        try {
            this.dbIds.addAll(this.hanaAccess.getDatabaseIds(false));
        }
        catch (InternalError e) {
            logger.error("Could not access SM", (Throwable)e);
        }
    }

    private boolean isLibContainerMissing(String dbId) {
        try {
            return this.hanaAccess.getInstance(this.getMtLibContainerName(dbId), false).isEmpty();
        }
        catch (InternalError e) {
            return true;
        }
    }

    private DbIdentifiers getDbIdentifiers() {
        this.insertDbIdsFromHana();
        return new DbIdentifiersHana(this.dbIds);
    }

    @Override
    public void insertDbIdentifiers(DbIdentifiers dbIdentifiers) {
        this.dbIds.addAll(((DbIdentifiersHana)dbIdentifiers).getDbIds());
    }

    @Override
    public DbIdentifiers.DB getDbType() {
        return DbIdentifiers.DB.HANA;
    }

    private String createDbKey(String host, String port) {
        return host + ":" + port;
    }

    private String getDatabaseId(Map<String, Object> credentials) {
        String databaseId = (String)credentials.get("database_id");
        if (StringUtils.isNotEmpty((CharSequence)databaseId)) {
            return databaseId;
        }
        databaseId = StringUtils.substringBefore((String)((String)credentials.get(HOST)), (String)".");
        return UuidChecker.isUUId((String)databaseId) ? databaseId : null;
    }
}

