/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import java.time.Duration;
import java.time.Instant;

public class PollingParameters {
    private Duration interval;
    private Duration requestTimeout;

    private PollingParameters() {
    }

    public <E extends Exception> boolean pollUntil(Until<E> untilSupplier) throws E {
        Instant start = Instant.now();
        boolean first = true;
        while (true) {
            boolean until = untilSupplier.calculateAndCheck(first);
            first = false;
            if (until || Duration.between(start, Instant.now()).compareTo(this.requestTimeout) > 0) {
                return until;
            }
            try {
                Thread.sleep(this.interval.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    public Duration getInterval() {
        return this.interval;
    }

    public void setInterval(Duration interval) {
        this.interval = interval;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @FunctionalInterface
    public static interface Until<E extends Exception> {
        public boolean calculateAndCheck(boolean var1) throws E;
    }

    public static final class Builder {
        private Duration interval = Duration.ofSeconds(5L);
        private Duration timeout = Duration.ofMinutes(10L);

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder interval(Duration interval) {
            this.interval = interval;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public PollingParameters build() {
            PollingParameters pollingParameters = new PollingParameters();
            pollingParameters.setInterval(this.interval);
            pollingParameters.setRequestTimeout(this.timeout);
            return pollingParameters;
        }
    }
}

