/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.exceptions.AuthorityError;

public interface SecurityChecker {
    public void checkSubscriptionAuthority() throws AuthorityError;

    public void checkInitDbAuthority() throws AuthorityError;

    default public void checkAuthority(Authority authority) throws AuthorityError {
        switch (authority) {
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                this.checkSubscriptionAuthority();
                break;
            }
            case INIT_DB: {
                this.checkInitDbAuthority();
            }
        }
    }

    public static enum Authority {
        SUBSCRIBE,
        UNSUBSCRIBE,
        INIT_DB;

    }
}

